/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.helper;

import com.schneide.base.application.usermanagement.dialog.CreateSchneideUserGroupDialog;
import com.schneide.base.application.usermanagement.dialog.EditSchneideUserGroupDialog;
import com.schneide.base.application.usermanagement.dialog.helper.AbstractSchneideSelectionDialog;
import com.schneide.base.application.usermanagement.dialog.helper.AdditionalInputHandler;
import com.schneide.base.application.usermanagement.dialog.helper.GroupTableModel;
import com.schneide.base.application.usermanagement.model.RightHandler;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.UserGroupHandler;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.system.Base;
import java.util.Optional;

public abstract class AbstractSchneideUserGroupSelectionDialog<U extends SchneideUser>
extends AbstractSchneideSelectionDialog<U> {
    private final UserGroupHandler groupHandler;
    private final RightHandler rightHandler;
    private final AdditionalInputHandler<U> additionalInputHandler;
    private final boolean showInternalInformation;

    public AbstractSchneideUserGroupSelectionDialog(WindowStack session, I18NKey baseKey, UserGroupHandler groupHandler, boolean showInternalInformation, RightHandler rightHandler, AdditionalInputHandler<U> additionaInputCreator) {
        super(session, baseKey, Base.getTextContent().getText("AbstractSchneideUserGroupSelectionDialog.type"), new GroupTableModel(groupHandler, showInternalInformation));
        this.groupHandler = groupHandler;
        this.rightHandler = rightHandler;
        this.additionalInputHandler = additionaInputCreator;
        this.showInternalInformation = showInternalInformation;
    }

    protected GroupTableModel getGroupTableModel() {
        return (GroupTableModel)this.getTableModel();
    }

    private boolean showInternalInformation() {
        return this.showInternalInformation;
    }

    @Override
    protected void createNewContentObject() {
        CreateSchneideUserGroupDialog<U> createDialog = new CreateSchneideUserGroupDialog<U>(this.getWindowStack(), this.showInternalInformation(), this.getGroupHandler(), this.getRightHandler(), this.getAdditionalInputHandler());
        Optional neueGruppe = createDialog.showDialog();
        neueGruppe.ifPresent(userGroup -> {
            userGroup.commit();
            this.getGroupTableModel().addEntry(userGroup);
        });
    }

    private UserGroupHandler getGroupHandler() {
        return this.groupHandler;
    }

    private RightHandler getRightHandler() {
        return this.rightHandler;
    }

    private AdditionalInputHandler<U> getAdditionalInputHandler() {
        return this.additionalInputHandler;
    }

    @Override
    protected void updateContentObjectAt(int index) {
        EditSchneideUserGroupDialog<U> editDialog = new EditSchneideUserGroupDialog<U>(this.getWindowStack(), this.getGroupTableModel().getUserGroupAt(index), this.showInternalInformation(), this.getGroupHandler(), this.getRightHandler(), this.getAdditionalInputHandler());
        editDialog.showDialog();
        if (editDialog.wasClosedByCommit()) {
            editDialog.updateUserGroup();
            this.getGroupTableModel().fireTableDataChanged();
        }
    }

    @Override
    protected void deleteContentObjectAt(int index) {
        this.getGroupTableModel().removeEntriesAt(index);
    }

    @Override
    protected String getEntryIdentifier(int index) {
        return this.getGroupTableModel().getUserGroupAt(index).getName();
    }
}

