/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.dialog.helper;

import com.schneide.base.application.usermanagement.dialog.SchneideUserGroupSelectionDialog;
import com.schneide.base.application.usermanagement.dialog.helper.AdditionalInputHandler;
import com.schneide.base.application.usermanagement.dialog.helper.CredentialGUIBuilder;
import com.schneide.base.application.usermanagement.dialog.helper.GroupListModel;
import com.schneide.base.application.usermanagement.dialog.helper.PasswordChangeDialog;
import com.schneide.base.application.usermanagement.model.RightHandler;
import com.schneide.base.application.usermanagement.model.SchneideCredential;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.SchneideUserGroup;
import com.schneide.base.application.usermanagement.model.UserGroupHandler;
import com.schneide.base.datatypes.collections.CollectionUtil;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.dialog.button.DialogButton;
import com.schneide.base.gui.dialog.button.NonvalidatingDialogButton;
import com.schneide.base.gui.i18n.DefaultI18NDisplayInformation;
import com.schneide.base.gui.i18n.DisplayInformation;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NKeyed;
import com.schneide.base.input.helper.LayoutHelper;
import com.schneide.base.input.inputs.CheckboxInput;
import com.schneide.base.input.inputs.PasswordInput;
import com.schneide.base.input.inputs.TextfieldInput;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.inputs.layout.StringGridBagLayoutStrategy;
import com.schneide.base.input.types.BooleanValue;
import com.schneide.base.input.types.StringValue;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.types.i18n.DefaultI18NValueInformation;
import com.schneide.base.input.types.i18n.ValueInformation;
import com.schneide.base.input.validation.EmptyInputResult;
import com.schneide.base.input.validation.ValidationAspect;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.input.validation.ValidationResultHolder;
import com.schneide.base.layout.GridBagLayoutPanel;
import com.schneide.base.layout.StringGridBagLayout;
import com.schneide.base.text.Text;
import com.schneide.base.text.transformation.Embrace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;

public abstract class AbstractSchneideUserDialog<U extends SchneideUser>
extends AbstractSchneideDialog<U> {
    private static final int DEFAULT_HEIGHT = 300;
    private final StringValue loginValue;
    private final StringValue fornameValue;
    private final StringValue surnameValue;
    private final StringValue passwordValue;
    private final BooleanValue internalValue;
    private final UserGroupHandler groupHandler;
    private final RightHandler rightHandler;
    private final U user;
    private final AdditionalInputHandler<U> additionalInputHandler;
    private final boolean showInternalInformation;
    private final GroupListModel groupModel;
    private final CredentialGUIBuilder credentialPanel;
    private String newPassword = "";

    public AbstractSchneideUserDialog(WindowStack session, I18NKey baseKey, U schneideUser, boolean showInternalInformation, UserGroupHandler groupHandler, RightHandler rightHandler, AdditionalInputHandler<U> additionalInputHandler) {
        super(session, (I18NKeyed)baseKey);
        this.showInternalInformation = showInternalInformation;
        this.groupHandler = groupHandler;
        this.rightHandler = rightHandler;
        this.user = schneideUser;
        this.additionalInputHandler = additionalInputHandler;
        this.loginValue = new StringValue((ValueInformation)new DefaultI18NValueInformation(this.getLevelFullKey("input.login"), new Object[0]), schneideUser.getLogIn());
        this.fornameValue = new StringValue((ValueInformation)new DefaultI18NValueInformation(this.getLevelFullKey("input.forname"), new Object[0]), schneideUser.getForename());
        this.surnameValue = new StringValue((ValueInformation)new DefaultI18NValueInformation(this.getLevelFullKey("input.surname"), new Object[0]), schneideUser.getSurname());
        this.passwordValue = new StringValue((ValueInformation)new DefaultI18NValueInformation(this.getLevelFullKey("input.password"), new Object[0]));
        this.internalValue = new BooleanValue((ValueInformation)new DefaultI18NValueInformation(this.getLevelFullKey("input.internal"), new Object[0]), Boolean.valueOf(schneideUser.getIsInternal()));
        this.groupModel = new GroupListModel(this.user.getUserGroups(), this.showInternalInformation);
        this.credentialPanel = new CredentialGUIBuilder(this.getWindowStack(), this.user.getCredentials(), this.showInternalInformation, this.getRightHandler());
        this.credentialPanel.buildUI();
    }

    protected StringValue getLoginValue() {
        return this.loginValue;
    }

    protected void buildUI() {
        PasswordInput passwordInput = new PasswordInput((Value)this.passwordValue);
        passwordInput.setEditable(false);
        NonvalidatingDialogButton changePasswordButton = new NonvalidatingDialogButton((DisplayInformation)new DefaultI18NDisplayInformation(this.getLevelFullKey("button.change.password"), new Object[0]));
        changePasswordButton.addActionListener(e -> new Thread(() -> {
            PasswordChangeDialog passwordChange = new PasswordChangeDialog(this.getWindowStack());
            passwordChange.showDialog();
            if (passwordChange.wasClosedByCommit()) {
                this.changePassword(passwordChange.getPassword());
            }
        }).start());
        this.addValidationAspects(new ValidationAspect[]{inputs -> {
            ValidationResultHolder validationResultHolder = new ValidationResultHolder();
            if (Text.isEmpty((String)this.passwordValue.getValue())) {
                validationResultHolder.addResult((ValidationResult)new EmptyInputResult((Input)passwordInput));
            }
            return validationResultHolder;
        }});
        DefaultI18NValueInformation groupInformation = new DefaultI18NValueInformation(this.getLevelFullKey("input.group.list"), new Object[0]);
        JList<String> groupList = new JList<String>(this.getGroupModel());
        groupList.setSelectionMode(2);
        NonvalidatingDialogButton addGroupButton = new NonvalidatingDialogButton((DisplayInformation)new DefaultI18NDisplayInformation(this.getLevelFullKey("button.add.group"), new Object[0]));
        addGroupButton.addActionListener(e -> new Thread(() -> {
            SchneideUserGroupSelectionDialog<U> selectionDialog = new SchneideUserGroupSelectionDialog<U>(this.getWindowStack(), this.getGroupHandler(), this.showInternalInformation, this.getRightHandler(), this.additionalInputHandler);
            selectionDialog.showDialog();
            if (selectionDialog.wasClosedByCommit()) {
                SchneideUserGroup userGroup = selectionDialog.getSelectedUserGroup();
                if (this.groupIsAlreadyAdded(userGroup)) {
                    this.getLogger().info((Object)("The current user (" + Embrace.withDoubleQuotes((Object)this.user.getLogIn()) + " is already a member of " + Embrace.withDoubleQuotes((Object)userGroup.getName()) + "."));
                    return;
                }
                this.getGroupModel().addGroup(userGroup);
            }
        }).start());
        NonvalidatingDialogButton removeGroupButton = new NonvalidatingDialogButton((DisplayInformation)new DefaultI18NDisplayInformation(this.getLevelFullKey("button.remove.group"), new Object[0]));
        removeGroupButton.setEnabled(false);
        removeGroupButton.addActionListener(e -> new Thread(() -> {
            if (!groupList.isSelectionEmpty()) {
                this.getGroupModel().removeGroupsAt(groupList.getSelectedIndices());
            }
        }).start());
        groupList.addListSelectionListener(arg_0 -> AbstractSchneideUserDialog.lambda$buildUI$7(groupList, (JButton)removeGroupButton, arg_0));
        JPanel changeGroupPanel = new JPanel((LayoutManager)new StringGridBagLayout());
        changeGroupPanel.add("anchor=SOUTH,gridx=0,gridy=0,fill=HORIZONTAL,insets=[5,5,5,5]", (Component)addGroupButton);
        changeGroupPanel.add("anchor=NORTH,gridx=0,gridy=1,fill=HORIZONTAL,insets=[5,5,5,5]", (Component)removeGroupButton);
        JScrollPane tableScrollPane = new JScrollPane((Component)this.credentialPanel.getCredentialTable());
        tableScrollPane.setPreferredSize(new Dimension(tableScrollPane.getWidth(), 300));
        GridBagLayoutPanel gridPanel = new GridBagLayoutPanel();
        SchneideUserDialogLayoutStrategy layoutStrategy = new SchneideUserDialogLayoutStrategy();
        LayoutHelper.addToPanel((JPanel)gridPanel, (LayoutStrategy)layoutStrategy, this.createInputList());
        layoutStrategy.addButtonInsteadOfUnitLabel((JPanel)gridPanel, (Input)passwordInput, (JButton)changePasswordButton);
        JScrollPane groupListScrollPane = new JScrollPane(groupList);
        groupListScrollPane.setPreferredSize(new Dimension(250, 130));
        layoutStrategy.addScrollPane((JPanel)gridPanel, (ValueInformation)groupInformation, groupListScrollPane, changeGroupPanel);
        layoutStrategy.addScrollPane((JPanel)gridPanel, this.credentialPanel.getDisplayInformation(), tableScrollPane, this.credentialPanel.getChangeCredentialPanel());
        gridPanel.setOpaque(true);
        this.setContent((JPanel)gridPanel);
        this.addButton().cancelButton();
        this.addButton().commitButton(this.createCommitButton());
    }

    protected List<Input> createInputList() {
        ArrayList<Input> inputList = new ArrayList<Input>();
        inputList.add((Input)new TextfieldInput((Value)this.loginValue));
        inputList.add((Input)new TextfieldInput((Value)this.fornameValue));
        inputList.add((Input)new TextfieldInput((Value)this.surnameValue));
        CollectionUtil.addAll(inputList, this.additionalInputHandler.getAdditionalSchneideUserInputs());
        if (this.showInternalInformation) {
            inputList.add((Input)new CheckboxInput((Value)this.internalValue));
        }
        return inputList;
    }

    protected final String getLevelFullKey(String keyPart) {
        return I18NKey.appendKeyParts((String[])new String[]{"AbstractSchneideUserDialog", keyPart});
    }

    private Iterable<SchneideCredential> getCredentials() {
        return this.credentialPanel.getCredentials();
    }

    private GroupListModel getGroupModel() {
        return this.groupModel;
    }

    public U getUser() {
        return this.user;
    }

    private UserGroupHandler getGroupHandler() {
        return this.groupHandler;
    }

    private RightHandler getRightHandler() {
        return this.rightHandler;
    }

    protected void changePassword(String newCleartextPassword) {
        this.newPassword = newCleartextPassword;
        this.indicateThatPassword(Text.hasContent((String)this.newPassword));
    }

    protected void indicateThatPassword(boolean isSet) {
        String value = "";
        if (isSet) {
            value = "*****";
        }
        this.passwordValue.setValue(value);
    }

    protected void updateUser() {
        this.getUser().update(this.loginValue.getValue(), this.fornameValue.getValue(), this.surnameValue.getValue(), this.internalValue.getValue(), this.getGroupModel().getGroups(), this.getCredentials());
        if (Text.hasContent((String)this.newPassword)) {
            this.getLogger().info((Object)"Changing user password!");
            this.getUser().changePassword(this.newPassword);
        }
        this.additionalInputHandler.updateAdditionalSchneideUserInputs();
    }

    protected boolean groupIsAlreadyAdded(SchneideUserGroup userGroup) {
        Iterable<SchneideUserGroup> containedGroups = this.getGroupModel().getGroups();
        return IterableUtil.contains(containedGroups, (Object)userGroup);
    }

    protected abstract DialogButton createCommitButton();

    protected Optional<U> giveAnswer() {
        this.updateUser();
        U result = this.getUser();
        return Optional.ofNullable(result);
    }

    private static /* synthetic */ void lambda$buildUI$7(JList groupList, JButton removeGroupButton, ListSelectionEvent e) {
        boolean isSelection = !groupList.isSelectionEmpty();
        removeGroupButton.setEnabled(isSelection);
    }

    private static class SchneideUserDialogLayoutStrategy
    extends StringGridBagLayoutStrategy {
        public void addButtonInsteadOfUnitLabel(JPanel panel, Input input, JButton button) {
            this.internalDefaultAddition(panel, input.getTitleLabel(), input.getInputComponent(), button);
        }

        public void addScrollPane(JPanel panel, ValueInformation valueInformation, JScrollPane scrollPane, JPanel buttonPanel) {
            this.internalAddTo(panel, new JComponent[]{new JLabel(valueInformation.getTitle()), scrollPane, buttonPanel}, new String[]{this.buildTitleLabelConstraints(), this.buildInputComponentConstraints() + "weighty=1, weightx=1, fill=BOTH", this.buildUnitLabelConstraints()});
        }
    }
}

