/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.data;

import com.schneide.base.application.usermanagement.model.Right;
import java.util.ArrayList;

public enum CredentialType {
    TOTAL(new TotalRightTraverser()),
    PUBLIC(new PublicRightTraverser());

    private final IRightTraverser traverser;

    private CredentialType(IRightTraverser traverser) {
        this.traverser = traverser;
    }

    public Right[] getVisibleChildren(Right parentRight) {
        if (parentRight == null) {
            return new Right[0];
        }
        return this.traverser.getVisibleChildren(parentRight);
    }

    private static interface IRightTraverser {
        public Right[] getVisibleChildren(Right var1);
    }

    private static class TotalRightTraverser
    implements IRightTraverser {
        @Override
        public Right[] getVisibleChildren(Right parentRight) {
            return parentRight.getChildren();
        }
    }

    private static class PublicRightTraverser
    implements IRightTraverser {
        @Override
        public Right[] getVisibleChildren(Right parentRight) {
            Right[] rights = parentRight.getChildren();
            ArrayList<Right> publicRightList = new ArrayList<Right>();
            for (Right right : rights) {
                if (right.getIsInternal()) continue;
                publicRightList.add(right);
            }
            return publicRightList.toArray(new Right[publicRightList.size()]);
        }
    }
}

