/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement.data;

import com.schneide.base.application.usermanagement.model.CredentialValueChangeListener;
import com.schneide.base.application.usermanagement.model.SchneideCredential;
import com.schneide.base.application.usermanagement.model.SchneideUserGroup;
import com.schneide.base.application.usermanagement.model.UserGroupValueChangeListener;
import com.schneide.base.application.usermanagement.news.UserGroupChanged;
import com.schneide.base.datatypes.IdentifierGenerator;
import com.schneide.base.datatypes.collections.CollectionUtil;
import com.schneide.base.datatypes.collections.iterable.EmptyIterable;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.News;
import com.schneide.base.listener.ListenerContainer;
import java.util.ArrayList;
import java.util.List;

public class BasicSchneideUserGroup
implements SchneideUserGroup,
CredentialValueChangeListener {
    private static final IdentifierGenerator IDENTIFIER = new IdentifierGenerator();
    private final List<SchneideCredential> credentialList;
    private final ListenerContainer<UserGroupValueChangeListener> changeListeners;
    private final EventBus eventBus;
    private String identifier;
    private boolean isInternal;
    private SchneideUserGroup parentGroup;
    private String name;
    private boolean isCommitted;

    public BasicSchneideUserGroup(boolean createIdentifier, EventBus eventBus) {
        this.eventBus = eventBus;
        this.isCommitted = false;
        if (createIdentifier) {
            this.identifier = IDENTIFIER.getNextIdentifier();
        }
        this.credentialList = new ArrayList<SchneideCredential>();
        this.changeListeners = new ListenerContainer();
    }

    public BasicSchneideUserGroup(String name, SchneideUserGroup parentGroup, boolean isInternal, EventBus eventBus) {
        this(true, eventBus);
        this.name = name;
        this.parentGroup = parentGroup;
        this.setCredentials((Iterable<SchneideCredential>)new EmptyIterable());
        this.isInternal = isInternal;
    }

    public BasicSchneideUserGroup(String name, EventBus eventBus) {
        this(name, null, false, eventBus);
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<SchneideCredential> getCredentials() {
        List<SchneideCredential> list = this.credentialList;
        synchronized (list) {
            return new ArrayList<SchneideCredential>(this.credentialList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCredential(SchneideCredential credential) {
        if (credential != null) {
            List<SchneideCredential> list = this.credentialList;
            synchronized (list) {
                this.credentialList.add(credential);
                this.notifyValueChanged();
                credential.addCredentialValueChangeListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCredential(SchneideCredential credential) {
        List<SchneideCredential> list = this.credentialList;
        synchronized (list) {
            credential.removeCredentialValueChangeListener(this);
            this.credentialList.remove(credential);
            this.notifyValueChanged();
        }
    }

    @Override
    public SchneideUserGroup getParentGroup() {
        return this.parentGroup;
    }

    @Override
    public boolean hasParentGroup() {
        return this.getParentGroup() != null;
    }

    @Override
    public boolean getIsInternal() {
        return this.isInternal;
    }

    public void setIsInternal(boolean isInternal) {
        this.isInternal = isInternal;
        this.notifyValueChanged();
    }

    public void setName(String name) {
        this.name = name;
        this.notifyValueChanged();
    }

    public void setParentGroup(SchneideUserGroup parentGroup) {
        this.parentGroup = parentGroup;
        this.notifyValueChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCredentials(Iterable<SchneideCredential> credentials) {
        List<SchneideCredential> list = this.credentialList;
        synchronized (list) {
            this.credentialList.clear();
            CollectionUtil.addAll(this.credentialList, credentials);
            this.notifyValueChanged();
        }
    }

    @Override
    public void update(String newName, SchneideUserGroup newParentGroup, boolean newIsInternal, Iterable<SchneideCredential> credentials) {
        this.name = newName;
        this.isInternal = newIsInternal;
        this.parentGroup = newParentGroup;
        this.setCredentials(credentials);
    }

    @Override
    public void notifyCredentialValueChanged(SchneideCredential newCredential) {
        this.notifyValueChanged();
    }

    protected void notifyValueChanged() {
        if (!this.isCommitted()) {
            return;
        }
        for (UserGroupValueChangeListener changeListener : this.changeListeners.getListeners()) {
            changeListener.notifyUserGroupValueChanged(this);
        }
        this.eventBus.publish((News)new UserGroupChanged(this));
    }

    @Override
    public void addUserGroupValueChangeListener(UserGroupValueChangeListener changeListener) {
        this.changeListeners.addListener((Object)changeListener);
    }

    @Override
    public void removeUserGroupValueChangeListener(UserGroupValueChangeListener changeListener) {
        this.changeListeners.removeListener((Object)changeListener);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SchneideUserGroup) {
            SchneideUserGroup reference = (SchneideUserGroup)obj;
            return this.getIdentifier().equals(reference.getIdentifier());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public boolean isCommitted() {
        return this.isCommitted;
    }

    @Override
    public void commit() {
        this.isCommitted = true;
    }
}

