/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.usermanagement;

import com.schneide.base.application.usermanagement.UserFinder;
import com.schneide.base.application.usermanagement.crypto.Password;
import com.schneide.base.application.usermanagement.internal.DenyInDoubtInferenceHandler;
import com.schneide.base.application.usermanagement.model.CredentialInferenceHandler;
import com.schneide.base.application.usermanagement.model.NoSuchUserException;
import com.schneide.base.application.usermanagement.model.RightIdentifier;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.UserDataHolder;
import com.schneide.base.application.usermanagement.model.UserManager;
import com.schneide.base.application.usermanagement.model.WrongLoginException;
import com.schneide.base.logging.LoggedObject;
import java.util.NoSuchElementException;

public class DefaultUserManager<T extends SchneideUser>
extends LoggedObject
implements UserManager<T> {
    private final UserDataHolder<T> userDataHolder;
    private final CredentialInferenceHandler credentialInferenceHandler;

    public DefaultUserManager(UserDataHolder<T> userDataHolder) {
        this.userDataHolder = userDataHolder;
        this.credentialInferenceHandler = new DenyInDoubtInferenceHandler(this.userDataHolder.getRightHandler());
    }

    private UserDataHolder<T> getUserDataHolder() {
        return this.userDataHolder;
    }

    private boolean checkLogin(String loginname, Password password) {
        if (this.hasUserWithLogin(loginname)) {
            T user = this.getUserFor(loginname);
            return user.isValidPassword(password);
        }
        return false;
    }

    private boolean hasUserWithLogin(String loginname) {
        try {
            this.getUserFor(loginname);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    @Override
    public T handleLogin(String loginname, Password password) throws NoSuchUserException, WrongLoginException {
        if (!this.checkLogin(loginname, password)) {
            throw new WrongLoginException();
        }
        T user = this.getUserFor(loginname);
        return user;
    }

    protected T getUserFor(String loginname) throws NoSuchElementException {
        return new UserFinder<T>().getUserFor(loginname, this.getUserDataHolder().getUserHandler().getAll());
    }

    public CredentialInferenceHandler getCredentialInferenceHandler() {
        return this.credentialInferenceHandler;
    }

    @Override
    public boolean hasPermission(T user, RightIdentifier credentialIdentifier) {
        if (null == credentialIdentifier) {
            return true;
        }
        boolean result = this.getCredentialInferenceHandler().hasPermission((SchneideUser)user, credentialIdentifier.getRepresentation());
        return result;
    }

    @Override
    public Iterable<T> getUsers() {
        return this.getUserDataHolder().getUserHandler().getAll();
    }
}

