/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.session;

import com.schneide.base.application.SchneideApplication;
import com.schneide.base.application.configuration.Configuration;
import com.schneide.base.application.interaction.model.ActionManager;
import com.schneide.base.application.usermanagement.model.RightIdentifier;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.News;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.gui.model.WindowStackProvider;
import com.schneide.base.lifecycle.LifeCycle;
import com.schneide.base.lifecycle.StopNotifier;
import com.schneide.base.lifecycle.dependent.DependentResourcesHost;
import com.schneide.base.util.Parameter;
import java.awt.Window;
import java.util.Optional;

public interface SchneideSession<USER extends SchneideUser>
extends Configuration,
LifeCycle,
DependentResourcesHost,
StopNotifier,
WindowStackProvider {
    public void setSessionProperty(Object var1, Object var2);

    public Optional<Object> getSessionProperty(Object var1);

    public Object removeSessionProperty(Object var1);

    default public Optional<Object> retrieveSessionProperty(Object key) {
        Optional<Object> result = this.getSessionProperty(key);
        this.removeSessionProperty(key);
        return result;
    }

    default public <T> Optional<T> retrieveSessionProperty(Class<T> key) {
        Optional<T> result = this.sessionPropertyFor(key, key);
        this.removeSessionProperty(key);
        return result;
    }

    default public <T> Optional<T> sessionPropertyFor(Class<T> keyAndType) {
        return this.sessionPropertyFor(keyAndType, keyAndType);
    }

    default public <T> Optional<T> sessionPropertyFor(Object key, Class<T> type) {
        Parameter.isPresent(type);
        return this.getSessionProperty(key);
    }

    public void showWindow(Window var1);

    public void showWindow(WindowStack var1, Window var2);

    public void hideWindow(Window var1);

    public void hideWindow(WindowStack var1, Window var2);

    public boolean isMainFrame(Window var1);

    public USER getUser();

    public boolean isAllowed(RightIdentifier var1);

    public void destroyVisualContent();

    public <S extends SchneideSession<USER>> ActionManager<S, USER> getActionManager();

    public SchneideApplication getApplication();

    public Iterable<WindowStack> getWindowStacks();

    public WindowStack getMainWindowStack();

    public WindowStack createNewWindowStack(String var1, Window ... var2);

    public void removeWindowStack(WindowStack var1);

    public EventBus getApplicationBus();

    default public void publish(News news) {
        this.getApplicationBus().publish(news);
    }
}

