/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.generic;

import com.schneide.base.application.process.UserCancelledProcess;
import com.schneide.base.application.process.generic.ActivationMethodFinder;
import com.schneide.base.application.process.generic.MethodInvoker;
import com.schneide.base.application.process.generic.Process;
import com.schneide.base.application.process.generic.ProcessReference;
import com.schneide.base.application.process.generic.ProcessRegistry;
import com.schneide.base.gui.dialog.defaults.fancy.ExceptionTextProvider;
import com.schneide.base.gui.dialog.defaults.fancy.FancyDialogInformation;
import com.schneide.base.gui.dialog.defaults.timed.TimedFancyDialog;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.text.parsing.StringChunker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.measure.Measurable;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;

public class ProcessStarter
extends MethodInvoker<Process> {
    public ProcessStarter() {
        super("process activation");
    }

    public void startProcess(ProcessReference processReference) {
        this.startProcess(processReference, processReference.getProcessInstance());
    }

    protected void startProcess(ProcessReference processReference, Process process) {
        ActivationMethodFinder methodFinder = new ActivationMethodFinder(processReference.getActivationMethodName());
        try {
            Method activationMethod = methodFinder.getCalledActivationMethod(process.getName(), process.getClass(), processReference.getContextProviders());
            this.invokeMethod(process, activationMethod, processReference.getContextProviders());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No suitable process activation method found for " + process.getName(), e);
        }
    }

    @Override
    protected void performBeforeInvocation(Process process) {
        ProcessRegistry.addRunningProcess(process);
    }

    @Override
    protected void performAfterInvocation(Process process) {
        ProcessRegistry.removeRunningProcess(process);
        process.cleanup();
    }

    @Override
    protected void handleException(Process process, InvocationTargetException e) {
        Throwable cause = e.getCause();
        ShowError displaying = this.displayingFor(cause);
        if (ShowError.NOT_HERE == displaying) {
            return;
        }
        if (ShowError.AS_CANCELLATION_IN_LOGS == displaying) {
            this.getLogger().debug((Object)("User cancelled execution of " + process.getName() + ": " + cause.getMessage()));
            return;
        }
        super.handleException(process, e);
        this.showErrorDialogForProcess(process, e);
    }

    private ShowError displayingFor(Throwable cause) {
        if (null == cause) {
            return ShowError.AS_DIALOG;
        }
        if (cause instanceof OutOfMemoryError) {
            return ShowError.NOT_HERE;
        }
        if (cause instanceof UserCancelledProcess) {
            return ShowError.AS_CANCELLATION_IN_LOGS;
        }
        return ShowError.AS_DIALOG;
    }

    protected void showErrorDialogForProcess(Process process, InvocationTargetException e) {
        ExceptionTextProvider textProvider = new ExceptionTextProvider(e.getCause(), (I18NResolvable)new DirectText("Ein Fehler trat bei der Ausf\u00fchrung des Prozesses '{0}' auf:", new Object[]{this.getPrintableProcessName(process)}));
        textProvider.setTitle((I18NResolvable)new DirectText("Fehler bei Prozessausf\u00fchrung"));
        TimedFancyDialog dialog = new TimedFancyDialog((FancyDialogInformation)textProvider, (Measurable)Amount.valueOf((long)30L, (Unit)SI.SECOND));
        dialog.show();
    }

    protected String getPrintableProcessName(Process forProcess) {
        StringChunker chunker = new StringChunker(forProcess.getName(), ".");
        return chunker.getLastChunk();
    }

    private static enum ShowError {
        AS_DIALOG,
        AS_CANCELLATION_IN_LOGS,
        NOT_HERE;

    }
}

