/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.cron.management;

import com.schneide.base.application.process.cron.management.Cancelable;
import com.schneide.base.application.process.cron.management.CronProcessManager;
import com.schneide.base.application.process.cron.management.Process;
import com.schneide.base.logging.LoggedObject;
import java.util.Date;
import org.joda.time.DateTime;
import org.quartz.CronTrigger;
import org.quartz.Trigger;

public abstract class TriggerBasedProcess
extends LoggedObject
implements Process,
Cancelable {
    private final Trigger trigger;
    private final CronProcessManager manager;

    public TriggerBasedProcess(Trigger trigger, CronProcessManager manager) {
        this.trigger = trigger;
        this.manager = manager;
    }

    @Override
    public String name() {
        return this.trigger().getJobName();
    }

    boolean isCanceled() {
        return this.manager.isCanceled(this);
    }

    protected DateTime nextFireTime() {
        return this.dateTime(this.trigger().getNextFireTime());
    }

    protected DateTime fireTimeAfterNextFireTime() {
        CronTrigger cronTrigger = (CronTrigger)this.trigger();
        return this.dateTime(cronTrigger.getFireTimeAfter(cronTrigger.getNextFireTime()));
    }

    boolean isRecurring() {
        return this.trigger() instanceof CronTrigger;
    }

    @Override
    public void cancel() {
        this.manager.cancel(this);
    }

    @Override
    public Trigger trigger() {
        return this.trigger;
    }

    private DateTime dateTime(Date date) {
        if (date == null) {
            return null;
        }
        return new DateTime((Object)date);
    }

    protected CronProcessManager manager() {
        return this.manager;
    }
}

