/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.cron.management;

import com.schneide.base.application.process.cron.management.Executor;
import com.schneide.base.application.process.cron.management.ExecutorSnapshot;
import com.schneide.base.application.process.cron.management.PendingProcess;
import com.schneide.base.application.process.cron.management.PendingProcessSnapshot;
import com.schneide.base.application.process.cron.management.ProcessManager;
import com.schneide.base.application.process.cron.management.UpcomingProcess;
import com.schneide.base.application.process.cron.management.UpcomingProcessSnapshot;
import com.schneide.base.timing.Clock;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;

public class ProcessManagerSnapshot
implements Serializable {
    private static final long serialVersionUID = -9078776486822119336L;
    private final DateTime timestamp = Clock.now();
    private List<Executor> executors = Collections.emptyList();
    private List<PendingProcessSnapshot> pendingProcesses = Collections.emptyList();
    private List<UpcomingProcessSnapshot> upcomingProcesses = Collections.emptyList();

    public ProcessManagerSnapshot withExecutors(List<Executor> execs) {
        ArrayList<Executor> snapshots = new ArrayList<Executor>();
        for (Executor executor : execs) {
            snapshots.add(new ExecutorSnapshot(executor));
        }
        this.executors = snapshots;
        return this;
    }

    public ProcessManagerSnapshot withPendingProcesses(List<PendingProcess> processes) {
        ArrayList<PendingProcessSnapshot> snapshots = new ArrayList<PendingProcessSnapshot>();
        for (PendingProcess process : processes) {
            snapshots.add(new PendingProcessSnapshot(process));
        }
        this.pendingProcesses = snapshots;
        return this;
    }

    public ProcessManagerSnapshot withUpcomingProcesses(List<UpcomingProcess> processes) {
        ArrayList<UpcomingProcessSnapshot> snapshots = new ArrayList<UpcomingProcessSnapshot>();
        for (UpcomingProcess process : processes) {
            snapshots.add(new UpcomingProcessSnapshot(process));
        }
        this.upcomingProcesses = snapshots;
        return this;
    }

    public List<Executor> executors() {
        return this.executors;
    }

    public List<PendingProcessSnapshot> pendingProcesses() {
        return this.pendingProcesses;
    }

    public List<UpcomingProcessSnapshot> upcomingProcesses() {
        return this.upcomingProcesses;
    }

    public static ProcessManagerSnapshot of(ProcessManager manager) {
        return new ProcessManagerSnapshot().withExecutors(manager.executors()).withPendingProcesses(manager.pendingProcesses()).withUpcomingProcesses(manager.upcomingProcesses(10));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Processes snapshot from " + String.valueOf(this.timestamp) + ":\n");
        result.append("Executing:\n");
        for (Executor executor : this.executors()) {
            result.append("* " + executor.name() + "\n");
        }
        result.append("Pending:\n");
        for (PendingProcessSnapshot pendingProcessSnapshot : this.pendingProcesses()) {
            result.append("+ " + pendingProcessSnapshot.name() + "\n");
        }
        result.append("Upcoming:\n");
        for (UpcomingProcessSnapshot upcomingProcessSnapshot : this.upcomingProcesses()) {
            result.append("- " + upcomingProcessSnapshot.name() + "\n");
        }
        return result.toString();
    }
}

