/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.cron.management;

import com.schneide.base.application.process.cron.management.UpcomingProcess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.ReadableInstant;

public final class CronProcessUtils {
    private CronProcessUtils() {
    }

    public static <U extends UpcomingProcess> List<U> mostUrgentOf(List<U> processes, int maximalCount) {
        List<U> all = CronProcessUtils.sortedByUrgency(processes);
        return all.subList(0, Math.min(all.size(), maximalCount));
    }

    protected static <U extends UpcomingProcess> List<U> sortedByUrgency(List<U> processes) {
        ArrayList<U> sorted = new ArrayList<U>(processes);
        Collections.sort(sorted, (p1, p2) -> p1.scheduledStartTime().compareTo((ReadableInstant)p2.scheduledStartTime()));
        return sorted;
    }
}

