/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.cron.management;

import com.schneide.base.application.process.cron.management.BusyExecutor;
import com.schneide.base.application.process.cron.management.CronProcessUtils;
import com.schneide.base.application.process.cron.management.CronTriggerManager;
import com.schneide.base.application.process.cron.management.Executor;
import com.schneide.base.application.process.cron.management.FreeExecutor;
import com.schneide.base.application.process.cron.management.JobBasedRunningProcess;
import com.schneide.base.application.process.cron.management.NextFireTimeComparator;
import com.schneide.base.application.process.cron.management.PendingProcess;
import com.schneide.base.application.process.cron.management.Process;
import com.schneide.base.application.process.cron.management.ProcessManager;
import com.schneide.base.application.process.cron.management.QuartzBasedTriggerFireTimes;
import com.schneide.base.application.process.cron.management.TriggerBasedPendingProcess;
import com.schneide.base.application.process.cron.management.TriggerBasedUpcomingProcess;
import com.schneide.base.application.process.cron.management.TriggerCanceler;
import com.schneide.base.application.process.cron.management.UpcomingProcess;
import com.schneide.base.application.process.cron.management.UpdateListener;
import com.schneide.base.i18n.NotI18NYet;
import com.schneide.base.listener.ListListenerHandler;
import com.schneide.base.listener.ListenerHandler;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.timing.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.listeners.TriggerListenerSupport;
import org.quartz.spi.ThreadPool;

public class CronProcessManager
extends LoggedObject
implements ProcessManager,
CronTriggerManager {
    private final ThreadPool threadPool;
    private final Scheduler scheduler;
    private final ListenerHandler<UpdateListener> updateListeners;
    private final TriggerListener triggerListener;
    private final TriggerCanceler triggerCanceler;

    public CronProcessManager(ThreadPool pool, Scheduler scheduler) {
        this(pool, scheduler, new TriggerCanceler());
    }

    protected CronProcessManager(ThreadPool pool, Scheduler scheduler, TriggerCanceler canceler) {
        this.threadPool = pool;
        this.scheduler = scheduler;
        this.triggerCanceler = canceler;
        this.updateListeners = new ListListenerHandler();
        this.triggerListener = new TriggerListener();
    }

    @Override
    public int numberOfExecutors() {
        return this.threadPool.getPoolSize();
    }

    @Override
    public List<Executor> executors() {
        ArrayList<Executor> executors = new ArrayList<Executor>();
        try {
            List<JobExecutionContext> runningJobs = this.runningJobContexts();
            int executorCount = this.numberOfExecutors();
            for (int i = 0; i < executorCount; ++i) {
                String name = new NotI18NYet("Einheit", new Object[0]).text() + " " + (i + 1);
                Executor executor = new FreeExecutor(name);
                if (i < runningJobs.size()) {
                    executor = new BusyExecutor(name, new JobBasedRunningProcess(runningJobs.get(i)));
                }
                executors.add(executor);
            }
        }
        catch (SchedulerException e) {
            this.getLogger().error((Object)"Could not obtain currently executing job contexts.", (Throwable)e);
        }
        return executors;
    }

    @Override
    public List<PendingProcess> pendingProcesses() {
        ArrayList<PendingProcess> processes = new ArrayList<PendingProcess>();
        for (Trigger trigger : this.nonCanceledOf(this.allTriggersSortedByFiringTime())) {
            TriggerBasedPendingProcess pending = new TriggerBasedPendingProcess(trigger, this);
            if (pending.isCanceled() || trigger.getNextFireTime() == null || !this.isInPast(trigger)) continue;
            processes.add(pending);
        }
        return processes;
    }

    @Override
    public List<UpcomingProcess> upcomingProcesses(int maxCount) {
        return CronProcessUtils.mostUrgentOf(this.allUpcomingProcesses(), maxCount);
    }

    private List<JobExecutionContext> runningJobContexts() throws SchedulerException {
        return this.scheduler().getCurrentlyExecutingJobs();
    }

    private List<UpcomingProcess> allUpcomingProcesses() {
        ArrayList<UpcomingProcess> processes = new ArrayList<UpcomingProcess>();
        for (Trigger trigger : this.allTriggersSortedByFiringTime()) {
            TriggerBasedUpcomingProcess upcoming = new TriggerBasedUpcomingProcess(trigger, this);
            if (upcoming.isCanceled() && !upcoming.isRecurring() || upcoming.scheduledStartTime() == null || this.isInPast(upcoming.scheduledStartTime())) continue;
            processes.add(upcoming);
        }
        return processes;
    }

    private List<Trigger> nonCanceledOf(Iterable<Trigger> triggers) {
        ArrayList<Trigger> result = new ArrayList<Trigger>();
        for (Trigger trigger : triggers) {
            if (this.triggerCanceler().isCanceled(trigger)) continue;
            result.add(trigger);
        }
        return result;
    }

    private List<Trigger> allTriggersSortedByFiringTime() {
        List<Trigger> triggers = this.allTriggers();
        Collections.sort(triggers, NextFireTimeComparator.byNextFireTime());
        return triggers;
    }

    private List<Trigger> allTriggers() {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        try {
            for (String groupName : this.scheduler().getJobGroupNames()) {
                for (String jobName : this.scheduler().getJobNames(groupName)) {
                    for (Trigger trigger : this.scheduler().getTriggersOfJob(jobName, groupName)) {
                        triggers.add(trigger);
                    }
                }
            }
        }
        catch (SchedulerException e) {
            this.getLogger().error((Object)"Could not obtain triggers.", (Throwable)e);
        }
        return triggers;
    }

    private boolean isInPast(Trigger trigger) {
        return this.isInPast(new DateTime((Object)trigger.getNextFireTime()));
    }

    private boolean isInPast(DateTime time) {
        return Clock.now().isAfter((ReadableInstant)time);
    }

    private Scheduler scheduler() {
        return this.scheduler;
    }

    protected TriggerCanceler triggerCanceler() {
        return this.triggerCanceler;
    }

    @Override
    public void addUpdateListener(UpdateListener listener) {
        this.updateListeners.addListener((Object)listener);
    }

    @Override
    public void removeUpdateListener(UpdateListener listener) {
        this.updateListeners.removeListener((Object)listener);
    }

    protected void notifyChange() {
        this.updateListeners.notifyListeners(listener -> listener.update());
    }

    public void start() {
        try {
            this.scheduler().addGlobalTriggerListener((org.quartz.TriggerListener)this.triggerListener);
        }
        catch (SchedulerException e) {
            this.getLogger().error((Object)"Could not register fired trigger tracker.", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.scheduler().removeGlobalTriggerListener(this.triggerListener.getName());
        }
        catch (SchedulerException e) {
            this.getLogger().error((Object)"Could not remove fired trigger tracker.", (Throwable)e);
        }
    }

    public void cancel(Process process) {
        this.triggerCanceler().cancel(process.trigger());
        this.notifyChange();
    }

    public void runNow(Process process) {
        try {
            this.scheduler().triggerJobWithVolatileTrigger(process.name(), process.trigger().getJobGroup());
            this.cancel(process);
        }
        catch (SchedulerException e) {
            this.getLogger().error((Object)("Could not execute cron process: " + process.name()), (Throwable)e);
        }
    }

    public boolean isCanceled(Process process) {
        return this.triggerCanceler().isCanceled(process.trigger());
    }

    @Override
    public CronTriggerManager.TriggerFireTimes fireTimesFor(String triggerName) throws NoSuchElementException {
        for (Trigger each : this.allTriggers()) {
            if (!triggerName.equals(each.getName())) continue;
            try {
                return this.fireTimesOf(each);
            }
            catch (SchedulerException e) {
                throw new NoSuchElementException("Could not determine the trigger specifics for " + triggerName);
            }
        }
        throw new NoSuchElementException("Could not find cron trigger with name " + triggerName);
    }

    protected CronTriggerManager.TriggerFireTimes fireTimesOf(Trigger trigger) throws SchedulerException {
        boolean isPaused = 1 == this.scheduler().getTriggerState(trigger.getName(), trigger.getGroup());
        return new QuartzBasedTriggerFireTimes(trigger, !isPaused);
    }

    private final class TriggerListener
    extends TriggerListenerSupport {
        public void triggerFired(Trigger trigger, JobExecutionContext context) {
            CronProcessManager.this.notifyChange();
        }

        public void triggerMisfired(Trigger trigger) {
            CronProcessManager.this.notifyChange();
        }

        public void triggerComplete(Trigger trigger, JobExecutionContext context, int triggerInstructionCode) {
            CronProcessManager.this.notifyChange();
        }

        public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
            return CronProcessManager.this.triggerCanceler().veto(trigger);
        }

        public String getName() {
            return "trigger listener";
        }
    }
}

