/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.cron;

import com.schneide.base.application.process.autoexecution.GenericProcessExecutionSpecification;
import com.schneide.base.application.process.cron.CronJobTimeoutSupervisor;
import com.schneide.base.application.process.cron.CronProcessExecutionSpecification;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.ConfigurationSection;
import com.schneide.base.properties.applicationLevel.BooleanProperty;
import com.schneide.base.properties.applicationLevel.PropertyReference;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import org.joda.time.Duration;

public class GenericCronProcessExecutionSpecification
extends GenericProcessExecutionSpecification
implements CronProcessExecutionSpecification {
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_EXECUTION_EXCLUSIVE = "exclusive.execution";
    private static final String KEY_PROCESS = "process.action";
    private static final String KEY_CRON_TRIGGER = "cron.trigger";
    private static final String KEY_PULSE_REFERENCE = "pulse";
    private static final String KEY_MAXIMUM_EXPECTED_EXECUTION_TIME = "max.expected.execution.time";
    private final String cronInformation;
    private final String pulseReference;
    private final Duration maximumExpectedExecutionTime;

    public GenericCronProcessExecutionSpecification(String processName, String denotation, String cronTrigger, boolean isEnabled, boolean isExecutionExclusive, String pulseReference, Duration maximumExpectedExecutionTime) {
        super(processName, denotation, isEnabled, isExecutionExclusive);
        this.cronInformation = cronTrigger;
        this.pulseReference = pulseReference;
        this.maximumExpectedExecutionTime = maximumExpectedExecutionTime;
    }

    @Override
    public String getCronInformation() {
        return this.cronInformation;
    }

    @Override
    public boolean isExecutionExclusive() {
        return this.isSynchronized();
    }

    @Override
    public String getPulseReference() {
        return this.pulseReference;
    }

    @Override
    public boolean hasPulseReference() {
        return this.getPulseReference() != null;
    }

    @Override
    public Duration getMaximumExpectedExecutionTime() {
        return this.maximumExpectedExecutionTime;
    }

    public static GenericCronProcessExecutionSpecification parseFrom(ConfigurationSection section) {
        String processName = section.getProperty(KEY_PROCESS).getValue();
        String denotation = section.getPartIdentifier();
        String cronTrigger = section.getProperty(KEY_CRON_TRIGGER).getValue();
        boolean isExecutionExculsive = GenericCronProcessExecutionSpecification.extractBooleanFrom(section, KEY_EXECUTION_EXCLUSIVE, false);
        boolean isEnabled = GenericCronProcessExecutionSpecification.extractBooleanFrom(section, KEY_ENABLED, true);
        String pulseReference = GenericCronProcessExecutionSpecification.extractStringFrom(section, KEY_PULSE_REFERENCE, null);
        Duration maximumExpectedExecutionTime = GenericCronProcessExecutionSpecification.extractDurationFrom(section, KEY_MAXIMUM_EXPECTED_EXECUTION_TIME, CronJobTimeoutSupervisor.DEFAULT_TIMEOUT);
        return new GenericCronProcessExecutionSpecification(processName, denotation, cronTrigger, isEnabled, isExecutionExculsive, pulseReference, maximumExpectedExecutionTime);
    }

    private static String extractStringFrom(ConfigurationSection section, String key, String standardValue) {
        if (section.hasProperty(key)) {
            return section.getProperty(key).getValue();
        }
        return standardValue;
    }

    private static boolean extractBooleanFrom(ConfigurationSection section, String key, boolean standardValue) {
        if (section.hasProperty(key)) {
            BooleanProperty property = BooleanProperty.buildConfigured((ConfigurationPart)section, (PropertyReferenceType)PropertyReference.forKey((String)key));
            return property.getValue();
        }
        return standardValue;
    }

    private static Duration extractDurationFrom(ConfigurationSection section, String key, Duration standardValue) {
        if (section.hasProperty(key)) {
            return CronJobTimeoutSupervisor.parseDuration(section.getProperty(key).getValue());
        }
        return standardValue;
    }
}

