/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.cron;

import com.schneide.base.application.process.cron.CronJobTimeoutSupervisor;
import com.schneide.base.application.process.cron.CronProcessExecutionSpecification;
import com.schneide.base.application.process.cron.GenericCronProcessExecutionSpecification;
import com.schneide.base.application.process.cron.ProcessJobProvider;
import com.schneide.base.application.process.cron.ScheduleAt;
import com.schneide.base.application.process.cron.SchneideProcessJobFactory;
import com.schneide.base.application.process.cron.management.CronProcessManager;
import com.schneide.base.application.process.cron.management.ProcessManager;
import com.schneide.base.application.selection.ProcessExecutionSelection;
import com.schneide.base.datatypes.collections.iterable.EmptyIterable;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.lifecycle.LifeCycle;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.Configuration;
import com.schneide.base.properties.ConfigurationSection;
import com.schneide.base.system.Base;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobFactory;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;

public class CronProcessStarter
extends LoggedObject
implements LifeCycle {
    private static final String CRON_PROCESS_SCHEDULER = "scheduler.schneide.cron";
    public static final String GROUP_CRONPROCESS = "cron processes";
    private static final String SECTION_AUTOPROCESS = "cronprocess";
    private final CronProcessExecutionSpecification[] specifications;
    private final ProcessJobProvider jobProvider;
    private Scheduler scheduler;
    private SimpleThreadPool threadPool;
    private SchneideProcessJobFactory jobFactory;
    private CronJobTimeoutSupervisor supervisor;

    public CronProcessStarter(VirtualFile configurationFile, ProcessJobProvider jobProvider, CronJobTimeoutSupervisor.NoCronThreadsAvailableProblemHandler problemHandler) {
        this(new Configuration(new VirtualFile[]{configurationFile}), jobProvider, problemHandler);
    }

    public CronProcessStarter(Configuration configuration, ProcessJobProvider jobProvider, CronJobTimeoutSupervisor.NoCronThreadsAvailableProblemHandler problemHandler) {
        this(CronProcessStarter.retrieveSpecifications(configuration), jobProvider, problemHandler);
    }

    public CronProcessStarter(CronProcessExecutionSpecification[] specifications, ProcessJobProvider jobProvider, CronJobTimeoutSupervisor.NoCronThreadsAvailableProblemHandler problemHandler) {
        this.specifications = specifications;
        this.jobProvider = jobProvider;
        try {
            this.threadPool = new SimpleThreadPool(2, 5);
            this.threadPool.setThreadsInheritGroupOfInitializingThread(false);
            this.threadPool.initialize();
            DirectSchedulerFactory.getInstance().createScheduler(CRON_PROCESS_SCHEDULER, "SIMPLE_NON_CLUSTERED", (ThreadPool)this.threadPool, (JobStore)new RAMJobStore());
            this.scheduler = DirectSchedulerFactory.getInstance().getScheduler(CRON_PROCESS_SCHEDULER);
            this.jobFactory = new SchneideProcessJobFactory();
            this.scheduler.setJobFactory((JobFactory)this.jobFactory);
            this.supervisor = new CronJobTimeoutSupervisor(this.scheduler, problemHandler);
        }
        catch (SchedulerException e) {
            this.getLogger().fatal((Object)"Could not instantiate cron jobs.", (Throwable)e);
        }
    }

    public void start() {
        try {
            this.scheduler.start();
            this.supervisor.start();
        }
        catch (SchedulerException e) {
            this.getLogger().error((Object)"Could not initialize scheduler for application cron jobs.", (Throwable)e);
        }
    }

    public void stop() {
        this.supervisor.stop();
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            this.getLogger().error((Object)"Could not shut down cron process scheduler.", (Throwable)e);
        }
    }

    public String getCronProcessTriggerGroupName() {
        return GROUP_CRONPROCESS;
    }

    public CronProcessExecutionSpecification[] getCronProcessSpecifications() {
        return this.specifications;
    }

    private static CronProcessExecutionSpecification[] retrieveSpecifications(Configuration configuration) {
        ConfigurationSection[] sections = configuration.getSections(SECTION_AUTOPROCESS);
        Base.getDefaultLogger().debug((Object)(sections.length + " Prozesse f\u00fcr Cronstart geladen."));
        ArrayList<GenericCronProcessExecutionSpecification> specificationList = new ArrayList<GenericCronProcessExecutionSpecification>();
        for (ConfigurationSection currentSection : sections) {
            specificationList.add(GenericCronProcessExecutionSpecification.parseFrom(currentSection));
        }
        return specificationList.toArray(new CronProcessExecutionSpecification[specificationList.size()]);
    }

    public void scheduleProcessesFor(ProcessExecutionSelection ... executionSelections) {
        this.scheduleProcessesFor(List.of(executionSelections));
    }

    public void scheduleProcessesFor(Iterable<ProcessExecutionSelection> executionSelections) {
        for (CronProcessExecutionSpecification element : this.getCronProcessSpecifications()) {
            this.scheduleCron(element, this.isSchedulingEnabled(element, executionSelections));
        }
    }

    private boolean isSchedulingEnabled(CronProcessExecutionSpecification element, Iterable<ProcessExecutionSelection> executionSelections) {
        boolean result = element.isEnabled();
        ProcessExecutionSelection selection = this.getExecutionSpecificationFor(element, executionSelections);
        if (null != selection) {
            result = selection.isEnabledForSchedule();
        }
        return result;
    }

    private ProcessExecutionSelection getExecutionSpecificationFor(CronProcessExecutionSpecification specification, Iterable<ProcessExecutionSelection> executionSelections) {
        for (ProcessExecutionSelection selection : executionSelections) {
            if (!specification.equals(selection.getSpecification())) continue;
            return selection;
        }
        return null;
    }

    private void scheduleCron(CronProcessExecutionSpecification specification, boolean isInitiallyEnabled) {
        String processName = specification.getProcessName();
        try {
            this.getJobFactory().registerJob(this.jobProvider.provideProcessJob(specification));
            CronTrigger trigger = new CronTrigger(specification.getDenotation(), GROUP_CRONPROCESS, processName, GROUP_CRONPROCESS, specification.getCronInformation());
            ScheduleAt.scheduler(this.getScheduler()).schneideProcessTriggeredBy((Trigger)trigger);
            this.getLogger().debug((Object)("Cron process " + processName + " scheduled."));
            if (!isInitiallyEnabled) {
                this.getLogger().debug((Object)("Cron process " + processName + " paused."));
                this.getScheduler().pauseTrigger(trigger.getName(), trigger.getGroup());
            }
        }
        catch (SchedulerException e) {
            this.getLogger().error((Object)("Could not schedule cron job for Process " + processName), (Throwable)e);
        }
        catch (ParseException e) {
            this.getLogger().error((Object)("Could not schedule cron job for Process " + processName), (Throwable)e);
        }
    }

    private SchneideProcessJobFactory getJobFactory() {
        return this.jobFactory;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public ProcessManager createProcessManager() {
        return new CronProcessManager((ThreadPool)this.threadPool, this.getScheduler());
    }

    public Iterable<Trigger> getCronTriggers() {
        try {
            ArrayList<Trigger> result = new ArrayList<Trigger>();
            for (String each : this.getScheduler().getTriggerNames(GROUP_CRONPROCESS)) {
                Trigger newTrigger = this.getScheduler().getTrigger(each, GROUP_CRONPROCESS);
                result.add(newTrigger);
            }
            return result;
        }
        catch (SchedulerException e) {
            this.getLogger().error((Object)"Could not obtain cron triggers.", (Throwable)e);
            return new EmptyIterable();
        }
    }
}

