/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.cron;

import com.schneide.base.application.process.cron.SchneideQuartzJob;
import com.schneide.base.datetime.PeriodParser;
import com.schneide.base.gui.dialog.defaults.fancy.DialogType;
import com.schneide.base.gui.dialog.defaults.fancy.FancyDialogInformation;
import com.schneide.base.gui.dialog.defaults.fancy.GenericDialogInformation;
import com.schneide.base.gui.dialog.defaults.timed.TimedFancyDialog;
import com.schneide.base.i18n.NotI18NYet;
import com.schneide.base.i18n.model.I18Nable;
import com.schneide.base.lifecycle.LifeCycle;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.Text;
import com.schneide.base.text.transformation.StringJoin;
import com.schneide.base.threading.DelayedLoopingExecutable;
import com.schneide.base.threading.Executable;
import com.schneide.base.threading.delay.Delay;
import com.schneide.base.threading.delay.LeadingDelay;
import com.schneide.base.timing.Clock;
import java.util.ArrayList;
import java.util.List;
import javax.measure.Measurable;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Minutes;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.jscience.physics.amount.Amount;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public class CronJobTimeoutSupervisor
extends LoggedObject
implements LifeCycle {
    public static final Duration DEFAULT_TIMEOUT = Minutes.minutes((int)5).toStandardDuration();
    private static final Duration CHECK_INTERVAL = Minutes.minutes((int)1).toStandardDuration();
    private static final PeriodFormatter DURATION_FORMATTER = new PeriodFormatterBuilder().appendHours().appendSuffix("h").appendSeparator(" ").appendMinutes().appendSuffix("m").appendSeparator(" ").appendSeconds().appendSuffix("s").toFormatter();
    private final Scheduler scheduler;
    private final Executable periodicChecker;
    private final NoCronThreadsAvailableProblemHandler problemHandler;
    private final Duration fallbackTimeOut;

    public CronJobTimeoutSupervisor(Scheduler scheduler, NoCronThreadsAvailableProblemHandler problemHandler) {
        this(scheduler, problemHandler, DEFAULT_TIMEOUT);
    }

    public CronJobTimeoutSupervisor(Scheduler scheduler, NoCronThreadsAvailableProblemHandler problemHandler, Duration fallbackTimeOut) {
        this.scheduler = scheduler;
        this.problemHandler = problemHandler;
        this.fallbackTimeOut = fallbackTimeOut;
        this.periodicChecker = new DelayedLoopingExecutable("Cron job timeout checker", (Delay)new LeadingDelay(CHECK_INTERVAL.getMillis())){

            protected void executeWithinLoop() throws Exception {
                CronJobTimeoutSupervisor.this.checkForTimedOutJobs();
            }
        };
    }

    public void start() {
        this.periodicChecker.startExecution();
    }

    public void stop() {
        this.periodicChecker.stopExecution();
    }

    protected void checkForTimedOutJobs() throws Exception {
        List<JobExecutionContext> timedOutJobs = this.determineTimedOutJobs();
        if (timedOutJobs.isEmpty()) {
            this.handleNoProblem();
            return;
        }
        this.warnAboutTimedOutJobs(timedOutJobs);
    }

    private List<JobExecutionContext> determineTimedOutJobs() {
        ArrayList<JobExecutionContext> result = new ArrayList<JobExecutionContext>();
        try {
            List activeJobs = this.scheduler.getCurrentlyExecutingJobs();
            for (JobExecutionContext job : activeJobs) {
                if (!this.hasTimedOut(job)) continue;
                result.add(job);
            }
        }
        catch (SchedulerException e) {
            this.getLogger().error((Object)"Error while checking for timed out jobs", (Throwable)e);
        }
        return result;
    }

    private boolean hasTimedOut(JobExecutionContext job) {
        return CronJobTimeoutSupervisor.executionTimeOf(job).isLongerThan((ReadableDuration)this.timeOutFor(job));
    }

    private Duration timeOutFor(JobExecutionContext job) {
        Job jobInstance = job.getJobInstance();
        if (jobInstance instanceof SchneideQuartzJob) {
            SchneideQuartzJob schneideQuartzJob = (SchneideQuartzJob)jobInstance;
            return schneideQuartzJob.getMaximumExpectedExecutionTime();
        }
        return this.fallbackTimeOut;
    }

    private static String nameOf(JobExecutionContext job) {
        return job.getTrigger().getJobName();
    }

    public static Duration executionTimeOf(JobExecutionContext job) {
        return new Duration((ReadableInstant)new DateTime((Object)job.getFireTime()), (ReadableInstant)Clock.now());
    }

    protected void warnAboutTimedOutJobs(List<JobExecutionContext> timedOutJobs) {
        this.logTimedOutJobs(timedOutJobs);
        this.handleProblem(timedOutJobs);
        this.showWarningDialog(timedOutJobs);
    }

    private void logTimedOutJobs(List<JobExecutionContext> timedOutJobs) {
        this.getLogger().warn((Object)"Timed out jobs detected:");
        for (JobExecutionContext job : timedOutJobs) {
            this.getLogger().warn((Object)this.timeoutInformationOf(job));
            Thread executingThread = this.executingThreadOf(job);
            if (executingThread == null) continue;
            for (StackTraceElement stackTraceElement : executingThread.getStackTrace()) {
                this.getLogger().warn((Object)stackTraceElement);
            }
        }
    }

    private Thread executingThreadOf(JobExecutionContext job) {
        Job jobInstance = job.getJobInstance();
        if (jobInstance instanceof SchneideQuartzJob) {
            SchneideQuartzJob schneideQuartzJob = (SchneideQuartzJob)jobInstance;
            return schneideQuartzJob.getExecutingThread();
        }
        return null;
    }

    private String itemizedTimeoutInformationOf(List<JobExecutionContext> timedOutJobs) {
        return StringJoin.separatedBy(timedOutJobs, (String)"\n", job -> Text.itemize((String)this.timeoutInformationOf((JobExecutionContext)job)));
    }

    private String timeoutInformationOf(JobExecutionContext job) {
        return new NotI18NYet("{0} (Bisherige Laufzeit: {1}, maximal erwartet: {2})", new Object[]{CronJobTimeoutSupervisor.nameOf(job), CronJobTimeoutSupervisor.formatDuration(CronJobTimeoutSupervisor.executionTimeOf(job)), CronJobTimeoutSupervisor.formatDuration(this.timeOutFor(job))}).text();
    }

    public static String formatDuration(Duration duration) {
        return DURATION_FORMATTER.print((ReadablePeriod)duration.toPeriod());
    }

    public static Duration parseDuration(String durationString) {
        return new PeriodParser().parseFrom(durationString.trim()).toStandardDuration();
    }

    protected void handleProblem(List<JobExecutionContext> timedOutJobs) {
        this.problemHandler.handleJobsTimedOut(timedOutJobs);
    }

    private void handleNoProblem() {
        this.problemHandler.handleNoJobsTimedOut();
    }

    protected void showWarningDialog(List<JobExecutionContext> timedOutJobs) {
        GenericDialogInformation dialogInfo = new GenericDialogInformation();
        dialogInfo.setTitle((I18Nable)new NotI18NYet("Lang andauernde Prozesse erkannt", new Object[0]));
        dialogInfo.setHeadline((I18Nable)new NotI18NYet("Es wurden lang andauernde Prozesse erkannt", new Object[0]));
        dialogInfo.setMessage((I18Nable)new NotI18NYet("Folgende Prozesse laufen bereits l\u00e4nger als erwartet:\n\n{0}\n\nEine lange Laufzeit stellt nicht notwendigerweise ein Problem dar.", new Object[]{this.itemizedTimeoutInformationOf(timedOutJobs)}));
        dialogInfo.setType(DialogType.WARNING);
        TimedFancyDialog dialog = new TimedFancyDialog((FancyDialogInformation)dialogInfo, (Measurable)Amount.valueOf((long)1L, (Unit)NonSI.HOUR));
        dialog.show();
    }

    public static interface NoCronThreadsAvailableProblemHandler {
        public void handleJobsTimedOut(List<JobExecutionContext> var1);

        public void handleNoJobsTimedOut();
    }
}

