/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.boot;

import com.schneide.base.application.ApplicationEngine;
import com.schneide.base.application.interaction.model.ActivationContextProvider;
import com.schneide.base.application.process.boot.BootProcessExecutionSpecification;
import com.schneide.base.application.process.boot.DefaultBootProcessExecutionSpecification;
import com.schneide.base.application.process.generic.AbstractBootProcess;
import com.schneide.base.application.process.generic.Process;
import com.schneide.base.application.process.generic.ProcessLoader;
import com.schneide.base.application.process.generic.ProcessReference;
import com.schneide.base.application.process.generic.ProcessStarter;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.Configuration;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.ConfigurationSection;
import com.schneide.base.properties.applicationLevel.BooleanProperty;
import com.schneide.base.properties.applicationLevel.PropertyReference;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import com.schneide.base.properties.applicationLevel.StringsProperty;
import com.schneide.base.system.Base;
import com.schneide.base.threading.SchneideThread;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class BootProcessExecutor
extends LoggedObject {
    private static final String PROCESS_PACKAGE = "process.package";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_SYNCHRONIZED = "synchronized";
    private static final String KEY_PROCESS = "process";
    private static final String SECTION_BOOTPROCESS = "bootprocess";
    private final String[] processPackages;
    private final BootProcessExecutionSpecification[] specifications;

    public BootProcessExecutor(VirtualFile configurationFile) {
        this(new Configuration(new VirtualFile[]{configurationFile}));
    }

    public BootProcessExecutor(Configuration configuration) {
        this(BootProcessExecutor.retrieveSpecifications(configuration));
    }

    public BootProcessExecutor(IBootProcessSpecification specification) {
        this.specifications = specification.getExecutionSpecifications();
        this.processPackages = specification.getProcessPackages();
    }

    private static IBootProcessSpecification retrieveSpecifications(Configuration configuration) {
        ConfigurationSection[] sections = configuration.getSections(SECTION_BOOTPROCESS);
        Base.getDefaultLogger().debug((Object)(sections.length + " Prozesse f\u00fcr Autostart geladen."));
        final ArrayList<DefaultBootProcessExecutionSpecification> specificationList = new ArrayList<DefaultBootProcessExecutionSpecification>();
        for (ConfigurationSection element : sections) {
            String processName = element.getProperty(KEY_PROCESS).getValue();
            String denotation = element.getPartIdentifier();
            boolean isSynchronized = BootProcessExecutor.extractBooleanFrom(element, KEY_SYNCHRONIZED, false);
            boolean isEnabled = BootProcessExecutor.extractBooleanFrom(element, KEY_ENABLED, true);
            specificationList.add(new DefaultBootProcessExecutionSpecification(processName, denotation, isEnabled, isSynchronized));
        }
        final String[] packageNames = StringsProperty.buildConfigured((ConfigurationPart)configuration, (PropertyReferenceType)PropertyReference.forKey((String)PROCESS_PACKAGE)).getValues();
        return new IBootProcessSpecification(){

            @Override
            public BootProcessExecutionSpecification[] getExecutionSpecifications() {
                return specificationList.toArray(new BootProcessExecutionSpecification[specificationList.size()]);
            }

            @Override
            public String[] getProcessPackages() {
                return packageNames;
            }
        };
    }

    private static boolean extractBooleanFrom(ConfigurationSection section, String key, boolean standardValue) {
        if (section.hasProperty(key)) {
            BooleanProperty property = BooleanProperty.buildConfigured((ConfigurationPart)section, (PropertyReferenceType)PropertyReference.forKey((String)key));
            return property.getValue();
        }
        return standardValue;
    }

    public <U extends SchneideUser> void execute(ApplicationEngine<? extends SchneideSession<U>, U> engine) {
        for (BootProcessExecutionSpecification element : this.specifications) {
            if (!element.isEnabled()) continue;
            try {
                this.executeProcess(element, engine);
            }
            catch (Exception e) {
                this.getLogger().error((Object)("The boot process " + element.getBootProcessName() + " could not be started."), (Throwable)e);
            }
        }
    }

    private <U extends SchneideUser, S extends SchneideSession<U>> void executeProcess(BootProcessExecutionSpecification specification, ApplicationEngine<S, U> engine) throws Exception {
        Constructor<Process> bootConstructor = ProcessLoader.retrieveConstructorFor(specification.getBootProcessName(), this.processPackages, AbstractBootProcess.class, EventBus.class);
        Process bootProcess = bootConstructor.newInstance(engine.getApplication().getApplicationBus());
        SchneideThread currentProcess = SchneideThread.createWorkerThread((String)specification.getDenotation(), new BootProcessWorkerThread<U, S>(this, engine, bootProcess));
        currentProcess.startThread();
        if (specification.isSynchronized()) {
            try {
                currentProcess.join();
            }
            catch (InterruptedException e) {
                Base.getLogger((Object)((Object)this)).warn((Object)"Interrupted.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private static interface IBootProcessSpecification {
        public String[] getProcessPackages();

        public BootProcessExecutionSpecification[] getExecutionSpecifications();
    }

    protected class BootProcessWorkerThread<U extends SchneideUser, S extends SchneideSession<U>>
    implements Runnable {
        private final ApplicationEngine<S, U> engine;
        private final Process bootProcess;

        public BootProcessWorkerThread(BootProcessExecutor this$0, ApplicationEngine<S, U> engine, Process bootProcess) {
            this.engine = engine;
            this.bootProcess = bootProcess;
        }

        protected ApplicationEngine<S, U> engine() {
            return this.engine;
        }

        protected Process bootProcess() {
            return this.bootProcess;
        }

        @Override
        public void run() {
            new ProcessStarter().startProcess(new ProcessReference(){

                @Override
                public ActivationContextProvider[] getContextProviders() {
                    return new ActivationContextProvider[]{BootProcessWorkerThread.this.engine().getProcessContextProvider()};
                }

                @Override
                public Process getProcessInstance() {
                    return BootProcessWorkerThread.this.bootProcess();
                }

                @Override
                public String getActivationMethodName() {
                    return "activateBoot";
                }
            });
        }
    }
}

