/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process;

import com.schneide.base.application.SchneideApplication;
import com.schneide.base.application.handler.ShutdownHandler;
import com.schneide.base.application.process.generic.AbstractSchneideProcess;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.gui.dialog.defaults.DefaultDialog;
import com.schneide.base.gui.dialog.defaults.QuestionDialog;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.I18NText;
import com.schneide.base.i18n.model.I18NResolvable;

public class ShutdownProcess
extends AbstractSchneideProcess<SchneideSession<? extends SchneideUser>> {
    public ShutdownProcess(SchneideSession<SchneideUser> session) {
        super(session);
    }

    public void activateFor(SchneideApplication application, ShutdownHandler<SchneideSession<? extends SchneideUser>> shutdownHandler) {
        if (this.thisIsReallyWanted(application)) {
            try {
                shutdownHandler.shutdownApplication((SchneideSession<? extends SchneideUser>)this.session());
            }
            catch (IllegalAccessException e) {
                this.getLogger().warn((Object)"Das Herunterfahren der Anwendung ist fehlgeschlagen.", (Throwable)e);
                DefaultDialog.showErrorDialog((WindowStack)this.session().getMainWindowStack(), (I18NKey)new I18NKey("ShutdownProcess.failed"), (Object[])new Object[0]);
            }
        }
    }

    protected boolean thisIsReallyWanted(SchneideApplication application) {
        return QuestionDialog.showYesNoDecisionDialog((WindowStack)this.session().getMainWindowStack(), (I18NResolvable)new I18NKey("ShutdownProcess.confirm.title"), (I18NResolvable)new I18NText("ShutdownProcess.confirm.message", new Object[]{application.getName()}));
    }
}

