/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process;

import com.schneide.base.application.process.generic.AbstractSchneideProcess;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.inspection.InspectableEventBus;

public class ShowNewsSubscribers
extends AbstractSchneideProcess<SchneideSession<? extends SchneideUser>> {
    public ShowNewsSubscribers(SchneideSession<SchneideUser> session) {
        super(session);
    }

    public void activateFor() {
        EventBus applicationBus = this.applicationBus();
        if (!(applicationBus instanceof InspectableEventBus)) {
            this.getLogger().warn((Object)"The currently used event bus isn't inspectable, so cannot give a list of its subscribers.");
            return;
        }
        this.inspect((InspectableEventBus)applicationBus);
    }

    private void inspect(InspectableEventBus eventBus) {
        this.getLogger().info((Object)("Got currently " + eventBus.subscriptionCount() + " subscribed news receivers on the application event bus."));
        eventBus.onSubscriptions(receiver -> {
            StringBuilder line = new StringBuilder();
            line.append(receiver.getClass().getSimpleName());
            line.append(": ");
            line.append(receiver.toString());
            this.getLogger().debug((Object)line);
        });
    }
}

