/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process;

import com.schneide.base.application.process.generic.AbstractSchneideProcess;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.gui.dialog.defaults.DefaultDialog;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.io.compression.FileZipper;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public abstract class AbstractZippedExportProcess
extends AbstractSchneideProcess<SchneideSession<?>> {
    public AbstractZippedExportProcess(SchneideSession<?> session) {
        super(session);
    }

    public void activateFor() {
        JFileChooser fileChooser = new JFileChooser((File)null);
        fileChooser.setFileFilter(new FileFilter(this){

            @Override
            public boolean accept(File arg0) {
                return arg0.getName().endsWith(".zip") || arg0.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Zip-Archive (*.zip)";
            }
        });
        fileChooser.setSelectedFile(this.getTargetFilePreselection());
        int answer = 0;
        if (this.canChooseTarget()) {
            answer = fileChooser.showSaveDialog(this.session().getMainWindowStack().getActiveWindow());
        }
        if (answer == 0) {
            this.exportToFile(fileChooser.getSelectedFile());
            DefaultDialog.showMessageDialog((WindowStack)this.session().getMainWindowStack(), (String)(this.getContentDescription() + " wurde in die Datei '" + fileChooser.getSelectedFile().getAbsolutePath() + "' kopiert."), (String)(this.getProgressDenotation() + " erfolgreich"));
        }
    }

    public void exportToFile(File file) {
        file.getParentFile().mkdirs();
        try {
            FileZipper zipper = new FileZipper(file, this.getZipComment());
            for (File element : this.getSourceFiles()) {
                zipper.addFile(element);
            }
            zipper.writeZip(FileZipper.CompressionLevel.HIGHEST);
            this.getLogger().info((Object)("Der gezippte Export von " + this.getProgressDenotation() + " ist abgeschlossen."));
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Beim gepackten Export traten Fehler auf.", (Throwable)e);
        }
    }

    protected boolean canChooseTarget() {
        return true;
    }

    protected abstract Iterable<File> getSourceFiles();

    public abstract File getTargetFilePreselection();

    protected abstract String getZipComment();

    protected abstract String getProgressDenotation();

    protected abstract String getContentDescription();
}

