/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.problem;

import com.schneide.base.eventbus.News;
import com.schneide.base.gui.dialog.defaults.DefaultDialog;
import com.schneide.base.gui.dialog.model.DialogOption;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.i18n.model.I18Nable;
import com.schneide.base.logging.LoggedObject;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class BlockingOperatorQuestion<A extends DialogOption>
extends LoggedObject
implements News {
    private final I18Nable message;
    private final I18Nable title;
    private final Iterable<A> possibleAnswers;
    private final BlockingQueue<A> answers;

    public BlockingOperatorQuestion(I18Nable title, I18Nable message, Iterable<A> possibleAnswers) {
        this.title = title;
        this.message = message;
        this.possibleAnswers = possibleAnswers;
        this.answers = new LinkedBlockingQueue<A>();
    }

    public A waitForAnswer() {
        DialogOption result = null;
        while (null == result) {
            try {
                result = (DialogOption)this.answers.take();
            }
            catch (InterruptedException e) {
                this.getLogger().error((Object)"Got interrupted while waiting for operator answer.", (Throwable)e);
            }
        }
        return (A)result;
    }

    private DialogOption[] options() {
        ArrayList<DialogOption> result = new ArrayList<DialogOption>();
        for (DialogOption each : this.possibleAnswers) {
            result.add(each);
        }
        return result.toArray(new DialogOption[result.size()]);
    }

    public void displayOn(WindowStack stack) {
        DialogOption chosen = (DialogOption)EDT.query(() -> DefaultDialog.showOptionDialog((WindowStack)stack, (String)this.title.resolvedText(), (String)this.message.resolvedText(), (DialogOption[])this.options(), (int)3));
        try {
            this.answers.put(chosen);
        }
        catch (InterruptedException e) {
            this.getLogger().error((Object)"Could not accept answer.", (Throwable)e);
        }
    }
}

