/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.periphery;

import com.schneide.base.application.module.ApplicationModule;
import com.schneide.base.application.module.ModuleException;
import com.schneide.base.application.module.ModuleStorage;
import com.schneide.base.application.periphery.ModuleRepository;
import com.schneide.base.capability.CapabilityResourceRegistry;
import com.schneide.base.capability.CapabilityStorage;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.lifecycle.LifeCycle;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.threading.executor.DoInBackground;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;

public class Periphery
extends LoggedObject
implements ModuleStorage,
ModuleRepository,
LifeCycle {
    private final List<ApplicationModule<?>> modules = new ArrayList();
    private final CapabilityStorage capabilities = new CapabilityStorage();

    public CapabilityStorage capabilityStorage() {
        return this.capabilities;
    }

    public CapabilityResourceRegistry capabilityRegistry() {
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void store(ApplicationModule<?> instance) {
        List<ApplicationModule<?>> list = this.modules;
        synchronized (list) {
            this.modules.add(instance);
            this.fragePeriodischAb(instance);
        }
    }

    private <M extends ApplicationModule<M>> void fragePeriodischAb(ApplicationModule<M> laufendesModul) {
        DoInBackground.now((String)("Abfrage von " + laufendesModul.bezeichnung()), () -> {
            Optional maybePeriodischeAbfrage = laufendesModul.periodischeAbfrage();
            if (maybePeriodischeAbfrage.isEmpty()) {
                return;
            }
            ApplicationModule.PeriodischeAbfrage periodischeAbfrage = (ApplicationModule.PeriodischeAbfrage)maybePeriodischeAbfrage.get();
            while (laufendesModul.isRunning()) {
                periodischeAbfrage.frageAb();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(ApplicationModule<?> stoppedModule) {
        List<ApplicationModule<?>> list = this.modules;
        synchronized (list) {
            this.modules.remove(stoppedModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <M extends ApplicationModule<?>> Iterable<M> getAllOf(Class<M> moduleClass) {
        List<ApplicationModule<?>> list = this.modules;
        synchronized (list) {
            ArrayList<ApplicationModule> result = new ArrayList<ApplicationModule>();
            for (ApplicationModule<?> each : this.modules) {
                if (!moduleClass.isInstance(each)) continue;
                result.add((ApplicationModule)moduleClass.cast(each));
            }
            return result;
        }
    }

    public <M extends ApplicationModule<?>> Optional<M> getFirstOf(Class<M> type) throws NoSuchElementException {
        Iterable<M> allOfType = this.getAllOf(type);
        if (IterableUtil.isEmpty(allOfType)) {
            return Optional.empty();
        }
        return Optional.of((ApplicationModule)IterableUtil.getElementAt((int)0, this.getAllOf(type)));
    }

    public void start() {
        this.capabilities.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.getLogger().info((Object)"Stopping all modules");
        List<ApplicationModule<?>> list = this.modules;
        synchronized (list) {
            for (ApplicationModule<?> each : this.modules) {
                try {
                    each.stopModule();
                }
                catch (ModuleException e) {
                    this.getLogger().error((Object)("Failed to stop periphery module " + each.specification().getDenotation()), (Throwable)e);
                }
            }
        }
        this.capabilities.stop();
    }

    @Override
    public Iterable<ApplicationModule<?>> all() {
        List<ApplicationModule<?>> result = this.allUnsorted();
        Collections.sort(result, this.alphabetically());
        return result;
    }

    private Comparator<ApplicationModule<?>> alphabetically() {
        return (o1, o2) -> o1.specification().getDenotation().compareTo(o2.specification().getDenotation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ApplicationModule<?>> allUnsorted() {
        List<ApplicationModule<?>> list = this.modules;
        synchronized (list) {
            return new ArrayList(this.modules);
        }
    }
}

