/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.news;

import com.schneide.base.eventbus.News;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.i18n.model.I18NResolvable;
import java.awt.Color;

public class SystemMessage
implements News {
    private final I18NResolvable message;
    private final MessageSeverity severity;

    public SystemMessage(CharSequence text) {
        this(text, MessageSeverity.INFO);
    }

    public SystemMessage(CharSequence text, MessageSeverity severity) {
        this((I18NResolvable)new DirectText(text.toString()), severity);
    }

    public SystemMessage(I18NResolvable message) {
        this(message, MessageSeverity.INFO);
    }

    public SystemMessage(I18NResolvable message, MessageSeverity severity) {
        this.message = message;
        this.severity = severity;
    }

    public String asString() {
        return this.message.resolvedText();
    }

    public MessageSeverity severity() {
        return this.severity;
    }

    public String toString() {
        return this.asString();
    }

    public static enum MessageSeverity {
        INFO(Color.GREEN),
        WARNING(Color.YELLOW),
        ERROR(Color.RED);

        private final Color color;

        private MessageSeverity(Color color) {
            this.color = color;
        }

        public Color color() {
            return this.color;
        }
    }
}

