/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.module.internal;

import com.schneide.base.application.module.ApplicationModule;
import com.schneide.base.application.module.GenericModuleEngine;
import com.schneide.base.application.module.ModuleCreator;
import com.schneide.base.application.module.ModuleMode;
import com.schneide.base.application.module.configuration.ModuleConfiguration;
import com.schneide.base.application.module.creation.ModuleCreationInformation;
import com.schneide.base.eventbus.EventBus;
import java.util.Arrays;
import java.util.Optional;

public class InformedModuleCreator
implements ModuleCreator {
    private final GenericModuleEngine engine;
    private final Iterable<ModuleCreationInformation> creationInformations;

    public InformedModuleCreator(Iterable<ModuleCreationInformation> creationInformations, EventBus applicationBus) {
        this.engine = new GenericModuleEngine(applicationBus);
        this.creationInformations = creationInformations;
    }

    @Override
    public void createAndStartFor(ApplicationModule<?> module, ModuleMode newMode) {
        Optional<SpecificModuleCreation> creationInformation = this.creationInformationFor(module);
        creationInformation.ifPresent(info -> this.engine.buildModuleFor(info.creation(), newMode, Arrays.asList(info.configuration())));
    }

    private Optional<SpecificModuleCreation> creationInformationFor(ApplicationModule<?> module) {
        String moduleId = module.specification().getIdentifier();
        String moduleName = module.specification().getDenotation();
        String moduleType = module.specification().getType().getIdentifier();
        for (ModuleCreationInformation each : this.creationInformations) {
            if (!moduleType.equals(each.getFactory().getModuleSpecification().getIdentifier())) continue;
            Iterable<ModuleConfiguration> configurations = each.getConfigurations();
            for (ModuleConfiguration moduleConfiguration : configurations) {
                if (!moduleId.equals(moduleConfiguration.getModuleInstanceIdentifier()) || !moduleName.equals(moduleConfiguration.getModuleInstanceDenotation())) continue;
                return Optional.of(new SpecificModuleCreation(this, each, moduleConfiguration));
            }
        }
        return Optional.empty();
    }

    private class SpecificModuleCreation {
        private final ModuleCreationInformation creation;
        private final ModuleConfiguration configuration;

        public SpecificModuleCreation(InformedModuleCreator informedModuleCreator, ModuleCreationInformation creation, ModuleConfiguration configuration) {
            this.creation = creation;
            this.configuration = configuration;
        }

        public ModuleCreationInformation creation() {
            return this.creation;
        }

        public ModuleConfiguration configuration() {
            return this.configuration;
        }
    }
}

