/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.module.gui;

import com.schneide.base.application.module.ModuleSpecification;
import com.schneide.base.application.module.icon.StateIcon;
import com.schneide.base.application.module.news.ModuleStarted;
import com.schneide.base.application.module.news.ModuleStateChanged;
import com.schneide.base.application.module.state.ModuleState;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.util.Subscriber;
import com.schneide.base.eventbus.util.SubscriberAttaching;
import com.schneide.base.gui.component.generic.UIComponent;
import com.schneide.base.gui.icon.IconProvider;
import com.schneide.base.gui.swing.EDT;
import javax.swing.JLabel;

public class ModuleStateIndicator
extends UIComponent<JLabel> {
    private final JLabel display;
    private final Subscriber<ModuleStateChanged> stateChanges;
    private final Subscriber<ModuleStarted> modeChanges;
    private ModuleSpecification forModule;

    public ModuleStateIndicator(ModuleSpecification forModule, ModuleState initialState) {
        this.forModule = forModule;
        this.display = (JLabel)EDT.query(() -> new JLabel());
        EDT.perform(() -> this.changeState(initialState));
        this.stateChanges = new Subscriber(ModuleStateChanged.class, news -> {
            if (forModule.getType().equals((Object)news.forModule())) {
                EDT.perform(() -> this.changeState(news.toState()));
            }
        });
        this.modeChanges = new Subscriber(ModuleStarted.class, news -> {
            ModuleSpecification newSpecification = news.module().specification();
            if (forModule.getType().equals((Object)newSpecification.getType())) {
                this.forModule = newSpecification;
                EDT.perform(() -> this.changeState(ModuleState.unknown));
            }
        });
    }

    private IconProvider iconFor(ModuleState state) {
        EDT.always();
        return StateIcon.onTopOf((IconProvider)((IconProvider)this.forModule.getMode().modeIcon().apply((Object)this.forModule.getIdentifier()))).forState(state.overlay());
    }

    public SubscriberAttaching subscribeTo(EventBus applicationBus) {
        SubscriberAttaching first = Subscriber.attach(this.stateChanges, (EventBus)applicationBus);
        SubscriberAttaching second = Subscriber.attach(this.modeChanges, (EventBus)applicationBus);
        return first.chainWith(second);
    }

    protected void changeState(ModuleState moduleState) {
        this.getLogger().debug((Object)("Changed displayed module state of " + this.forModule.getDenotation() + " to " + String.valueOf(moduleState.denotation())));
        EDT.always();
        this.display.setIcon(this.iconFor(moduleState).icon());
        this.display.setToolTipText(this.forModule.getDenotation() + ": " + moduleState.denotation().resolvedText());
    }

    protected JLabel buildComponent() {
        EDT.always();
        return this.display;
    }
}

