/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.module;

import com.schneide.base.application.module.AdditionalParameters;
import com.schneide.base.application.module.ApplicationModule;
import com.schneide.base.application.module.ModuleEngine;
import com.schneide.base.application.module.ModuleException;
import com.schneide.base.application.module.ModuleFactory;
import com.schneide.base.application.module.ModuleMode;
import com.schneide.base.application.module.configuration.ModuleConfiguration;
import com.schneide.base.application.module.creation.ModuleCreationInformation;
import com.schneide.base.application.module.news.ModuleStarted;
import com.schneide.base.application.module.news.ModuleStateChanged;
import com.schneide.base.application.module.state.ModuleState;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.News;
import com.schneide.base.gui.icon.IconProvider;
import com.schneide.base.gui.icon.NoIcon;
import com.schneide.base.gui.splash.BootMessageLogger;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.io.virtual.wrapper.DeveloperOverdrive;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.util.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

public class GenericModuleEngine
extends LoggedObject
implements ModuleEngine {
    private final BootMessageLogger messageLogger;
    private final EventBus applicationBus;

    public GenericModuleEngine(EventBus applicationBus) {
        this(applicationBus, message -> {});
    }

    public GenericModuleEngine(EventBus applicationBus, BootMessageLogger messageLogger) {
        this.applicationBus = applicationBus;
        this.messageLogger = messageLogger;
    }

    @Override
    public void buildModules(Iterable<ModuleCreationInformation> creationInformations) {
        for (ModuleCreationInformation each : creationInformations) {
            for (ModuleConfiguration eachConfiguration : each.getConfigurations()) {
                List<ModuleConfiguration> singledOutConfiguration = Arrays.asList(eachConfiguration);
                this.buildModuleFor(each, this.retrieveModeFrom(each.getFactory(), singledOutConfiguration), singledOutConfiguration);
            }
        }
    }

    private ModuleMode retrieveModeFrom(ModuleFactory<? extends ApplicationModule<?>> factory, Iterable<ModuleConfiguration> configurations) {
        for (ModuleConfiguration configuration : configurations) {
            try {
                return factory.getModeFor(configuration.getSelectedModeIdentifier());
            }
            catch (NoSuchElementException e) {
                this.getLogger().fatal((Object)("Invalid mode for module " + factory.getModuleSpecification().getDenotation() + " selected: " + configuration.getSelectedModeIdentifier()), (Throwable)e);
            }
        }
        throw new NoSuchElementException("Cannot determine module mode for " + factory.getModuleSpecification().getDenotation());
    }

    public void buildModuleFor(ModuleCreationInformation creationInformation, ModuleMode mode, Iterable<ModuleConfiguration> configurations) {
        for (ModuleConfiguration each : configurations) {
            ApplicationModule<?> instance = this.moduleInstanceFor(each, creationInformation, mode);
            creationInformation.performStartActionsFor(instance);
            creationInformation.getInstanceHandler().store(instance);
            this.applicationBus.publish((News)new ModuleStarted(instance));
            this.applicationBus.publish((News)this.stateChangeOf(instance));
        }
    }

    private ApplicationModule<?> moduleInstanceFor(ModuleConfiguration configuration, ModuleCreationInformation creationInformation, ModuleMode mode) {
        this.messageLogger.logBootMessage(creationInformation.getFactory().getModuleSpecification().getDenotation());
        ApplicationModule<?> instance = null;
        DeveloperOverdrive configurationFile = DeveloperOverdrive.of((VirtualFile)LocalVirtualFile.at((String)configuration.getModuleSpecificConfiguration()));
        if (!configurationFile.isFile()) {
            this.getLogger().warn((Object)("Die Konfigurationsdatei " + configurationFile.getName() + " konnte nicht geladen werden."));
        }
        try {
            instance = creationInformation.getFactory().buildModule(configuration.getModuleInstanceIdentifier(), configuration.getModuleInstanceDenotation(), mode, (VirtualFile)configurationFile, (AdditionalParameters)creationInformation);
        }
        catch (ModuleException e) {
            instance = this.handleModuleException(mode, creationInformation.getFactory(), configuration, instance, (VirtualFile)configurationFile, e);
        }
        creationInformation.performCreationActionsFor(instance);
        try {
            instance.startModule();
        }
        catch (ModuleException e) {
            instance = this.handleModuleException(mode, creationInformation.getFactory(), configuration, instance, (VirtualFile)configurationFile, e);
        }
        return instance;
    }

    private ApplicationModule<?> handleModuleException(ModuleMode mode, ModuleFactory<? extends ApplicationModule<?>> factory, ModuleConfiguration configuration, ApplicationModule<?> instance, VirtualFile configurationFile, ModuleException e) {
        Parameter.arePresent((Object[])new Object[]{factory, configuration, configurationFile});
        this.moduleBuildingFailed(e, mode);
        return instance;
    }

    private void moduleBuildingFailed(Throwable e, ModuleMode mode) {
        this.getLogger().fatal((Object)("Module cannot be initialized: " + mode.getDenotation()), e);
    }

    private ModuleStateChanged stateChangeOf(final ApplicationModule<?> chosenInstance) {
        return new ModuleStateChanged(chosenInstance.specification().getType(), new ModuleState(){

            @Override
            public IconProvider overlay() {
                return new NoIcon();
            }

            @Override
            public I18NResolvable denotation() {
                return new DirectText(chosenInstance.specification().getMode().getDenotation());
            }
        });
    }
}

