/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.module;

import com.schneide.base.application.module.ApplicationModule;
import com.schneide.base.application.module.ModuleFactory;
import com.schneide.base.application.module.ModuleStartAction;
import com.schneide.base.application.module.ModuleStorage;
import com.schneide.base.application.module.configuration.ModuleConfiguration;
import com.schneide.base.application.module.creation.ConfigurableModuleCreationInformation;
import com.schneide.base.application.module.creation.ModuleCreationAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class GenericModuleCreationInformation
implements ConfigurableModuleCreationInformation {
    private final Iterable<ModuleConfiguration> configuration;
    private final ModuleFactory<? extends ApplicationModule<?>> factory;
    private final ModuleStorage instanceHandler;
    private final List<ModuleCreationAction> creationActions;
    private final List<ModuleStartAction> startActions;
    private final Map<Class<?>, Object> additionalParameters;

    public GenericModuleCreationInformation(Iterable<ModuleConfiguration> configuration, ModuleFactory<? extends ApplicationModule<?>> factory, ModuleStorage instanceHandler) {
        this.configuration = configuration;
        this.factory = factory;
        this.instanceHandler = instanceHandler;
        this.creationActions = new ArrayList<ModuleCreationAction>();
        this.startActions = new ArrayList<ModuleStartAction>();
        this.additionalParameters = new HashMap();
        this.addAdditionalFor(ModuleStorage.class, instanceHandler);
    }

    @Override
    public Iterable<ModuleConfiguration> getConfigurations() {
        return this.configuration;
    }

    @Override
    public ModuleFactory<? extends ApplicationModule<?>> getFactory() {
        return this.factory;
    }

    @Override
    public ModuleStorage getInstanceHandler() {
        return this.instanceHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performCreationActionsFor(ApplicationModule<?> instance) {
        List<ModuleCreationAction> list = this.creationActions;
        synchronized (list) {
            this.creationActions.forEach(action -> action.performWith(instance));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performStartActionsFor(ApplicationModule<?> instance) {
        List<ModuleStartAction> list = this.startActions;
        synchronized (list) {
            this.startActions.forEach(action -> action.performWith(instance));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Optional<T> additionalInformationFor(Class<T> type) {
        Map<Class<?>, Object> map = this.additionalParameters;
        synchronized (map) {
            return Optional.ofNullable(this.additionalParameters.get(type)).map(type::cast);
        }
    }

    public <T> GenericModuleCreationInformation withAdditional(Class<T> type, T additionalParameter) {
        this.addAdditionalFor(type, additionalParameter);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addAdditionalFor(Class<T> type, T additionalParameter) {
        Map<Class<?>, Object> map = this.additionalParameters;
        synchronized (map) {
            this.additionalParameters.put(type, additionalParameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ModuleCreationAction action) {
        List<ModuleCreationAction> list = this.creationActions;
        synchronized (list) {
            this.creationActions.add(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ModuleStartAction action) {
        List<ModuleStartAction> list = this.startActions;
        synchronized (list) {
            this.startActions.add(action);
        }
    }
}

