/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.loaders;

import com.schneide.base.application.loaders.UnparseableVersionException;
import com.schneide.base.application.version.Version;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.Configuration;
import com.schneide.base.text.StringUtil;
import com.schneide.base.timing.Clock;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.joda.time.DateTime;

public class VersionInfoFileLoader
extends LoggedObject {
    private final String name;
    private final String version;
    private final String nickname;
    private final String buildDate;
    private final String buildNumber;
    private final String buildCommit;
    private final String buildId;

    public VersionInfoFileLoader(VirtualFile versionFile) {
        Configuration configuration = new Configuration(new VirtualFile[]{versionFile});
        this.name = configuration.getPropertyValue("name");
        this.version = configuration.getPropertyValue("version");
        this.nickname = configuration.getPropertyValue("version.nickname");
        this.buildDate = configuration.getPropertyValue("build.date");
        this.buildNumber = configuration.getPropertyValue("build.number");
        this.buildCommit = configuration.getPropertyValue("build.commit");
        this.buildId = configuration.getPropertyValue("build.id");
    }

    public String getApplicationName() {
        return this.name;
    }

    public Version getVersion() throws UnparseableVersionException {
        DateTime actualBuildDate = this.parseBuildDate(this.buildDate);
        return new LoadedVersion(this.parseVersionNumber(actualBuildDate), this.version, this.nickname, this.build());
    }

    protected long parseVersionNumber(DateTime actualBuildDate) {
        SimpleDateFormat numericFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return Long.parseLong(numericFormat.format(actualBuildDate.toDate()));
    }

    protected long parseBuildNumber(String givenBuildNumber) throws UnparseableVersionException {
        try {
            if (givenBuildNumber.isEmpty()) {
                return -1L;
            }
            return Long.parseLong(givenBuildNumber);
        }
        catch (NumberFormatException e) {
            throw new UnparseableVersionException("The version information for the build number could not be parsed: " + givenBuildNumber, e);
        }
    }

    protected DateTime parseBuildDate(String givenBuildDate) throws UnparseableVersionException {
        try {
            DateTime parsedDate = this.getNow();
            if (!givenBuildDate.isEmpty()) {
                SimpleDateFormat buildDateFormat = new SimpleDateFormat("dd.MM.yyyy");
                parsedDate = new DateTime((Object)buildDateFormat.parse(givenBuildDate));
            }
            return parsedDate;
        }
        catch (ParseException e) {
            throw new UnparseableVersionException("The version information for the build date could not be parsed: " + givenBuildDate, e);
        }
    }

    protected DateTime getNow() {
        return Clock.now();
    }

    private Version.Build build() {
        return new Version.Build(){

            @Override
            public String id() {
                String result = VersionInfoFileLoader.this.buildId;
                if (StringUtil.isEmptyOrNull((String)result)) {
                    return "undefined (development)";
                }
                return result;
            }

            @Override
            public String commit() {
                return VersionInfoFileLoader.this.buildCommit;
            }

            @Override
            public long number() {
                return VersionInfoFileLoader.this.parseBuildNumber(VersionInfoFileLoader.this.buildNumber);
            }

            @Override
            public DateTime date() {
                return VersionInfoFileLoader.this.parseBuildDate(VersionInfoFileLoader.this.buildDate);
            }
        };
    }

    private static final class LoadedVersion
    implements Version {
        private final long versionNumber;
        private final String versionDenotation;
        private final String versionNickname;
        private final Version.Build build;

        private LoadedVersion(long versionNumber, String versionDenotation, String versionNickname, Version.Build build) {
            this.versionNumber = versionNumber;
            this.versionDenotation = versionDenotation;
            this.versionNickname = versionNickname;
            this.build = build;
        }

        @Override
        public String denotation() {
            return this.versionDenotation;
        }

        @Override
        public String nickname() {
            return this.versionNickname;
        }

        @Override
        public long number() {
            return this.versionNumber;
        }

        @Override
        public Version.Build build() {
            return this.build;
        }

        public String toString() {
            return this.denotation();
        }
    }
}

