/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.loaders;

import com.schneide.base.application.interaction.configuration.ActionLoaderConfiguration;
import com.schneide.base.application.interaction.model.ActionSpecification;
import com.schneide.base.application.interaction.model.implementation.ProcessActionSpecification;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.io.file.FileUtil;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.Configuration;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.ConfigurationSection;
import com.schneide.base.properties.applicationLevel.PropertyReference;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import com.schneide.base.properties.applicationLevel.StringsProperty;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ActionSpecificationLoader<S extends SchneideSession<U>, U extends SchneideUser>
extends LoggedObject {
    private final ActionLoaderConfiguration loaderConfiguration;
    private Map<String, ActionSpecification<S, U>> actionSpecificationMap;

    public ActionSpecificationLoader(ActionLoaderConfiguration actionSpecification) {
        this.loaderConfiguration = actionSpecification;
        this.actionSpecificationMap = new HashMap<String, ActionSpecification<S, U>>();
    }

    public void load() throws IOException {
        HashMap<String, ActionSpecification<S, U>> result = new HashMap<String, ActionSpecification<S, U>>();
        Iterable<ActionSpecification<S, U>> publicActions = this.loadSpecifications(this.loaderConfiguration.getActionSpecificationFile(), false);
        for (ActionSpecification<S, U> specification : publicActions) {
            result.put(specification.getReferenceName(), specification);
        }
        Iterable<ActionSpecification<S, U>> internalActions = this.loadSpecifications(this.loaderConfiguration.getInternalActionSpecificationFile(), true);
        for (ActionSpecification<S, U> specification : internalActions) {
            result.put(specification.getReferenceName(), specification);
        }
        this.actionSpecificationMap = result;
    }

    public synchronized ActionSpecification<S, U> getActionSpecification(String referenceName) throws NoSuchElementException {
        if (this.actionSpecificationMap.containsKey(referenceName)) {
            return this.actionSpecificationMap.get(referenceName);
        }
        throw new NoSuchElementException("Eine Aktion mit Referenznamen '" + referenceName + "' wurde nicht gefunden.");
    }

    protected Iterable<ActionSpecification<S, U>> loadSpecifications(File actionSpecificationFile, boolean isInternal) throws IOException {
        ConfigurationSection[] actionSections;
        this.ensureFileIsAccessible(actionSpecificationFile);
        ArrayList<ActionSpecification<S, U>> result = new ArrayList<ActionSpecification<S, U>>();
        Configuration actionConfiguration = new Configuration(new VirtualFile[]{new LocalVirtualFile(actionSpecificationFile)});
        StringsProperty processPackage = StringsProperty.buildConfigured((ConfigurationPart)actionConfiguration, (PropertyReferenceType)PropertyReference.forKey((String)"process.package"));
        for (ConfigurationSection element : actionSections = actionConfiguration.getSections("action")) {
            ActionSpecification<S, U> specification = this.loadSpecification(element, processPackage.getValues(), isInternal);
            result.add(specification);
        }
        return result;
    }

    private void ensureFileIsAccessible(File actionSpecificationFile) throws IOException {
        if (!FileUtil.isReadableFile((File)actionSpecificationFile)) {
            throw new IOException("Die Spezifikationsdatei f\u00fcr Systemaktionen konnte nicht geladen werden: " + String.valueOf(actionSpecificationFile));
        }
    }

    private ActionSpecification<S, U> loadSpecification(ConfigurationSection section, String[] processPackages, boolean isInternal) {
        String reference = section.getIdentifier();
        String process = section.getProperty("process").getValue();
        String denotation = null;
        if (section.hasProperty("denotation")) {
            denotation = section.getProperty("denotation").getValue();
        }
        return new ProcessActionSpecification(reference, process, processPackages, denotation, isInternal);
    }

    public synchronized Iterable<ActionSpecification<S, U>> getActionSpecifications() {
        Collection<ActionSpecification<S, U>> specificationCollection = this.actionSpecificationMap.values();
        return specificationCollection;
    }

    public synchronized String[] getActionReferences() {
        Set<String> referenceSet = this.actionSpecificationMap.keySet();
        return referenceSet.toArray(new String[referenceSet.size()]);
    }
}

