/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.interaction.model.implementation;

import com.schneide.base.application.interaction.i18n.MenuItemI18N;
import com.schneide.base.application.interaction.model.ActionManager;
import com.schneide.base.application.interaction.model.MenuItemSpecification;
import com.schneide.base.application.interaction.model.MenuItemType;
import com.schneide.base.application.interaction.model.implementation.AbstractSpecification;
import com.schneide.base.application.process.generic.ProcessActivationMethod;
import com.schneide.base.application.process.generic.SchneideAction;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.gui.icon.IconLoader;
import com.schneide.base.util.EqualsBuilder;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class SwingMenuItemSpecification<S extends SchneideSession<U>, U extends SchneideUser>
extends AbstractSpecification
implements MenuItemSpecification<S, U> {
    private final Icon icon;
    private final String actionReference;
    private final ActionManager<S, U> actionManager;
    private final MenuItemType type;

    public SwingMenuItemSpecification(ActionManager<S, U> actionManager, MenuItemType type, String reference, String iconFileName, String actionReference, boolean isInternal) {
        super(reference, isInternal);
        this.actionManager = actionManager;
        this.type = type;
        this.icon = this.loadIcon(iconFileName);
        this.actionReference = actionReference;
    }

    public void setI18NResource(MenuItemI18N resource) {
        super.internalSetI18NResource(resource);
    }

    @Override
    public String getActionReference() {
        return this.actionReference;
    }

    @Override
    public KeyStroke getAccelerator() {
        KeyStroke result = null;
        if (this.getI18NResource() != null) {
            result = ((MenuItemI18N)this.getI18NResource()).getAccelerator();
        }
        return result;
    }

    protected Icon loadIcon(String iconFilename) {
        ImageIcon result = null;
        if (iconFilename != null && !".".equals(iconFilename)) {
            result = IconLoader.loadIcon((String)iconFilename);
        }
        return result;
    }

    @Override
    public MenuItemType getMenuItemType() {
        return this.type;
    }

    @Override
    public SchneideAction<S, U> getAction(S session) {
        try {
            return this.actionManager.getAction(this.getActionReference(), session, this.getDisplayText(), ProcessActivationMethod.USER_STARTED, new Object[]{this.type});
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public Iterable<Object> getValuesToCompare() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.actionManager);
        result.add(this.actionReference);
        result.add(this.icon);
        return result;
    }

    @Override
    public int hashCode() {
        return EqualsBuilder.hashCodeFor((EqualsBuilder.EqualComparable)this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.isEqual((EqualsBuilder.EqualComparable)this, (Object)obj);
    }
}

