/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.interaction.model.implementation;

import com.schneide.base.application.interaction.model.ActionSpecification;
import com.schneide.base.application.process.generic.AbstractSchneideProcess;
import com.schneide.base.application.process.generic.Process;
import com.schneide.base.application.process.generic.ProcessLoader;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.logging.LoggedObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ProcessActionSpecification<S extends SchneideSession<U>, U extends SchneideUser>
extends LoggedObject
implements ActionSpecification<S, U> {
    private static final String THE_INSTANTIATION_OF_THE_PROCESS_OBJECT = "The instantiation of the process object ";
    private final String referenceName;
    private final String processDisplayName;
    private final boolean isInternal;
    private final String targetProcessName;
    private final String[] processPackageNames;

    public ProcessActionSpecification(String referenceName, String targetProcessName, String[] processPackageNames) {
        this(referenceName, targetProcessName, processPackageNames, null, false);
    }

    public ProcessActionSpecification(String referenceName, String targetProcessName, String[] processPackageNames, String processDisplayName, boolean isInternal) {
        this.isInternal = isInternal;
        this.referenceName = referenceName;
        this.processDisplayName = processDisplayName == null || processDisplayName.trim().length() < 1 ? ProcessActionSpecification.determineProcessDisplayName(targetProcessName) : processDisplayName;
        this.targetProcessName = targetProcessName;
        this.processPackageNames = processPackageNames;
    }

    private Constructor<Process> resolveProcessName() throws ClassNotFoundException {
        return ProcessLoader.retrieveConstructorFor(this.getTargetProcessName(), this.processPackageNames, AbstractSchneideProcess.class, SchneideSession.class);
    }

    @Override
    public boolean isResolvable() {
        try {
            this.resolveProcessName();
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static String determineProcessDisplayName(String targetProcessName) {
        return targetProcessName;
    }

    public String getTargetProcessName() {
        return this.targetProcessName;
    }

    @Override
    public String getProcessDisplayName() {
        return this.processDisplayName;
    }

    @Override
    public String getReferenceName() {
        return this.referenceName;
    }

    @Override
    public boolean isInternal() {
        return this.isInternal;
    }

    @Override
    public AbstractSchneideProcess<S> getTargetProcess(S session) {
        try {
            Constructor<Process> targetProcessConstructor = this.resolveProcessName();
            try {
                return (AbstractSchneideProcess)targetProcessConstructor.newInstance(session);
            }
            catch (InstantiationException e) {
                this.getLogger().error((Object)(THE_INSTANTIATION_OF_THE_PROCESS_OBJECT + this.getTargetProcessName() + " failed."), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.getLogger().error((Object)(THE_INSTANTIATION_OF_THE_PROCESS_OBJECT + this.getTargetProcessName() + " failed because of security settings."), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.getLogger().error((Object)(THE_INSTANTIATION_OF_THE_PROCESS_OBJECT + this.getTargetProcessName() + " failed because of an invocation error."), (Throwable)e);
            }
        }
        catch (ClassNotFoundException e1) {
            this.getLogger().error((Object)("The given process name '" + this.getTargetProcessName() + "' could not be found."), (Throwable)e1);
        }
        return null;
    }
}

