/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.interaction.model.implementation;

import com.schneide.base.application.interaction.model.MenuBarSpecification;
import com.schneide.base.application.interaction.model.Specification;
import com.schneide.base.application.interaction.model.implementation.AbstractSpecification;
import com.schneide.base.application.interaction.model.implementation.SwingMenuItemSpecification;
import com.schneide.base.application.interaction.model.implementation.SwingMenuSpecification;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.logging.LoggedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class GenericMenuBarSpecification<S extends SchneideSession<U>, U extends SchneideUser>
extends LoggedObject
implements MenuBarSpecification<S, U> {
    private final List<SwingMenuSpecification<S, U>> menuList = new ArrayList<SwingMenuSpecification<S, U>>();
    private final Map<String, AbstractSpecification> referencesMap = new HashMap<String, AbstractSpecification>();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result;
        if (this.menuList != null) {
            result += this.menuList.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericMenuBarSpecification other = (GenericMenuBarSpecification)obj;
        return !(this.menuList == null ? other.menuList != null : !this.menuList.equals(other.menuList));
    }

    public void addMenu(SwingMenuSpecification<S, U> specification) {
        if (specification != null) {
            this.menuList.add(specification);
            this.saveReference(specification);
        }
    }

    protected void saveReference(AbstractSpecification specification) {
        this.referencesMap.put(specification.getReferenceName(), specification);
    }

    protected void deleteReference(AbstractSpecification specification) {
        this.referencesMap.remove(specification.getReferenceName());
    }

    public void addMenuItem(String menuReference, SwingMenuItemSpecification<S, U> specification) {
        if (specification != null && menuReference != null) {
            try {
                SwingMenuSpecification<S, U> menu = this.getMenu(menuReference);
                menu.addMenuItem(specification);
                this.saveReference(specification);
            }
            catch (NoSuchElementException e) {
                this.getLogger().warn((Object)"Vergeblicher Zugriff", (Throwable)e);
            }
        }
    }

    public void removeMenu(SwingMenuSpecification<S, U> specification) {
        if (specification != null) {
            this.menuList.remove(specification);
            this.deleteReference(specification);
        }
    }

    public void removeMenuItem(String menuReference, SwingMenuItemSpecification<S, U> specification) {
        if (specification != null && menuReference != null) {
            try {
                SwingMenuSpecification<S, U> menu = this.getMenu(menuReference);
                menu.removeMenuItem(specification);
                this.deleteReference(specification);
            }
            catch (NoSuchElementException e) {
                this.getLogger().warn((Object)"Das Element wurde nicht gefunden.", (Throwable)e);
            }
        }
    }

    public Specification getSpecification(String referenceName) throws NoSuchElementException {
        if (referenceName != null && this.referencesMap.containsKey(referenceName)) {
            return this.referencesMap.get(referenceName);
        }
        throw new NoSuchElementException("Die Spezifikation '" + referenceName + "' wurde in der gespeicherten Tabelle nicht gefunden.");
    }

    public SwingMenuSpecification<S, U> getMenu(String reference) throws NoSuchElementException {
        if (reference != null) {
            for (SwingMenuSpecification<S, U> element : this.menuList) {
                if (!reference.equals(element.getReferenceName())) continue;
                return element;
            }
        }
        throw new NoSuchElementException("Die Spezifikation des Menus '" + reference + "' wurde nicht gefunden.");
    }

    @Override
    public Iterable<SwingMenuSpecification<S, U>> getMenus() {
        return new ArrayList<SwingMenuSpecification<S, U>>(this.menuList);
    }
}

