/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.interaction.i18n;

import com.schneide.base.logging.LoggedObject;

public abstract class AbstractI18N
extends LoggedObject {
    private static final int INVALID_MNEMONIC = -1;
    private final String displayText;
    private final int mnemonic;

    public AbstractI18N(String displayText) {
        this(displayText, null);
    }

    public AbstractI18N(String displayText, String mnemonic) {
        this.displayText = displayText;
        this.mnemonic = this.setupMnemonic(mnemonic);
    }

    protected int setupMnemonic(String mnemonicString) {
        if (mnemonicString != null) {
            char mnemonicChar = mnemonicString.charAt(0);
            if (this.isIllegalMnemonic(mnemonicChar)) {
                return -1;
            }
            return mnemonicChar;
        }
        return -1;
    }

    private boolean isIllegalMnemonic(char mnemonicChar) {
        return mnemonicChar == '.' || mnemonicChar == ' ' || mnemonicChar == '?';
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public boolean hasMnemonic() {
        return this.mnemonic != -1;
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result;
        if (this.displayText != null) {
            result *= this.displayText.hashCode();
        }
        result = 31 * result + this.mnemonic;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractI18N other = (AbstractI18N)((Object)obj);
        if (this.displayText == null ? other.displayText != null : !this.displayText.equals(other.displayText)) {
            return false;
        }
        return this.mnemonic == other.mnemonic;
    }
}

