/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.gui.process;

import com.schneide.base.application.process.cron.management.Cancelable;
import com.schneide.base.application.process.cron.management.Executor;
import com.schneide.base.application.process.cron.management.PendingProcess;
import com.schneide.base.application.process.cron.management.ProcessManager;
import com.schneide.base.application.process.cron.management.UpcomingProcess;
import com.schneide.base.application.process.cron.management.UpdateListener;
import com.schneide.base.gui.component.util.ColumnSizeCalculator;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.i18n.NotI18NYet;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.lifecycle.LifeCycle;
import com.schneide.base.text.transformation.Embrace;
import com.schneide.base.threading.DelayedLoopingExecutable;
import com.schneide.base.threading.Executable;
import com.schneide.base.threading.delay.Delay;
import com.schneide.base.threading.delay.LeadingDelay;
import com.schneide.base.timing.Clock;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;

public class CronProcessManagerDisplay
implements LifeCycle,
UpdateListener {
    private static final String WRAP = "wrap";
    private static final String NOT_AVAILABLE = "n/a";
    private static final int UPCOMING_MAX_COUNT = 3;
    private final ProcessManager manager;
    private final Executable updater;
    private JPanel panel;
    private JPanel panelRunning;
    private JPanel panelPending;
    private JPanel panelUpcoming;

    public CronProcessManagerDisplay(ProcessManager processManager) {
        this.manager = processManager;
        this.updater = new DelayedLoopingExecutable("cron process manager display updater", (Delay)new LeadingDelay(3000L)){

            protected void executeWithinLoop() throws Exception {
                CronProcessManagerDisplay.this.update();
            }
        };
        this.buildUI();
    }

    protected void buildUI() {
        this.panel = new JPanel((LayoutManager)new MigLayout());
        this.addCaption(this.panel, (I18NResolvable)new NotI18NYet("In Bearbeitung", new Object[0]));
        this.panelRunning = this.addProcessPanelTo(this.panel);
        this.addCaption(this.panel, (I18NResolvable)new NotI18NYet("Wartend", new Object[0]));
        this.panelPending = this.addProcessPanelTo(this.panel);
        this.addCaption(this.panel, (I18NResolvable)new NotI18NYet("Anstehend", new Object[0]));
        this.panelUpcoming = this.addProcessPanelTo(this.panel);
        this.update();
    }

    @Override
    public void update() {
        EDT.perform(() -> {
            this.updateRunningProcesses();
            this.updatePendingProcesses();
            this.updateUpcomingProcesses();
            this.getPanel().revalidate();
        });
    }

    private void updateRunningProcesses() {
        this.panelRunning.removeAll();
        for (Executor each : this.manager().executors()) {
            String processName = "-";
            if (!each.isFree()) {
                processName = each.process().name();
            }
            String text = each.name() + ": " + processName;
            this.panelRunning.add((Component)this.createProcessLabel(text), WRAP);
        }
    }

    private void updatePendingProcesses() {
        this.panelPending.removeAll();
        List<PendingProcess> pending = this.manager().pendingProcesses();
        if (pending.isEmpty()) {
            this.panelPending.add(this.createProcessLabel(new NotI18NYet("keine", new Object[0]).text()));
            return;
        }
        for (PendingProcess process : pending) {
            this.panelPending.add(this.createProcessLabel(process.name()));
            this.panelPending.add((Component)this.cancelButton(process), WRAP);
        }
    }

    private void updateUpcomingProcesses() {
        this.panelUpcoming.removeAll();
        List<UpcomingProcess> upcoming = this.manager().upcomingProcesses(3);
        for (int i = 0; i < 3; ++i) {
            if (i < upcoming.size()) {
                UpcomingProcess process = upcoming.get(i);
                this.panelUpcoming.add(this.createProcessLabel(this.informationLineFor(process)));
                this.panelUpcoming.add(this.runNowButton(process));
                this.panelUpcoming.add((Component)this.cancelButton(process), WRAP);
                continue;
            }
            this.panelUpcoming.add((Component)this.createProcessLabel(NOT_AVAILABLE), WRAP);
        }
    }

    private JPanel addProcessPanelTo(JPanel parent) {
        JPanel pane = new JPanel((LayoutManager)new MigLayout());
        parent.add((Component)pane, WRAP);
        return pane;
    }

    private JLabel createProcessLabel(String text) {
        JLabel label = new JLabel(text);
        ColumnSizeCalculator.setColumnWidth((JComponent)label, (int)40);
        return label;
    }

    private JButton runNowButton(UpcomingProcess process) {
        JButton button = new JButton(new NotI18NYet(">", new Object[0]).text());
        button.setToolTipText(new NotI18NYet("Sofort ausf\u00fchren", new Object[0]).text());
        button.addActionListener(e -> {
            process.runNow();
            this.update();
        });
        return button;
    }

    private JButton cancelButton(Cancelable cancelable) {
        JButton button = new JButton(new NotI18NYet("X", new Object[0]).text());
        button.setToolTipText(new NotI18NYet("Abbrechen", new Object[0]).text());
        button.addActionListener(e -> {
            cancelable.cancel();
            this.update();
        });
        return button;
    }

    private void addCaption(JPanel pane, I18NResolvable text) {
        JLabel label = new JLabel(text.resolvedText());
        label.setFont(label.getFont().deriveFont(1));
        pane.add((Component)label, WRAP);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    protected String informationLineFor(UpcomingProcess process) {
        return this.formatDurationUntil(process.scheduledStartTime()).text() + " " + Embrace.withParentheses((Object)process.scheduledStartTime().toString("HH:mm")) + ": " + process.name();
    }

    protected NotI18NYet formatDurationUntil(DateTime startTime) {
        int minutes = Minutes.minutesBetween((ReadableInstant)Clock.now(), (ReadableInstant)startTime).getMinutes();
        if (minutes < 1) {
            return new NotI18NYet("sofort", new Object[0]);
        }
        if (minutes == 1) {
            return new NotI18NYet("in 1 Minute", new Object[0]);
        }
        return new NotI18NYet("in {0} Minuten", new Object[]{minutes});
    }

    private ProcessManager manager() {
        return this.manager;
    }

    public void start() {
        this.updater.startExecution();
        this.manager().addUpdateListener(this);
    }

    public void stop() {
        this.updater.stopExecution();
        this.manager().removeUpdateListener(this);
    }
}

