/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.gui.image;

import com.schneide.base.logging.LoggedObject;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.Random;

public class CameraNoiseGenerator
extends LoggedObject {
    private final BufferedImage originalImage;

    public CameraNoiseGenerator(Dimension size) {
        Random randomizer = new Random();
        this.originalImage = new BufferedImage(size.width, size.height, 1);
        for (int x = 0; x < this.originalImage.getWidth(); ++x) {
            for (int y = 0; y < this.originalImage.getHeight(); ++y) {
                this.changePixel(x, y, randomizer);
            }
        }
    }

    private void changePixel(int x, int y, Random randomizer) {
        int grayLevel = randomizer.nextInt(256);
        int rgb = (grayLevel << 16) + (grayLevel << 8) + grayLevel;
        this.originalImage.setRGB(x, y, rgb);
    }

    public BufferedImage asBufferedImage() {
        return this.originalImage;
    }

    public RenderedImage asRenderedImage() {
        return this.originalImage;
    }

    public Image asImage() {
        return this.originalImage;
    }

    public int type() {
        return this.originalImage.getType();
    }
}

