/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.gui.about;

import com.schneide.base.application.ApplicationInformation;
import com.schneide.base.application.gui.about.AboutInformation;
import com.schneide.base.io.file.FileLocator;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.properties.Configuration;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.ConfigurationSection;
import com.schneide.base.properties.applicationLevel.PropertyReference;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import com.schneide.base.properties.applicationLevel.StringProperty;
import com.schneide.base.properties.applicationLevel.StringsProperty;
import com.schneide.base.system.Base;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.swing.ImageIcon;

public class SchneideAboutInformation
implements AboutInformation {
    private final ApplicationInformation information;
    private final String description;
    private final ImageIcon applicationLogo;
    private final ImageIcon manufacturerLogo;
    private final String[] team;
    private final String homepageLink;

    public SchneideAboutInformation(ApplicationInformation information, String description, ImageIcon logo, ImageIcon schneideLogo, String homepageLink, String[] team) {
        this.information = information;
        this.description = description;
        this.applicationLogo = logo;
        this.manufacturerLogo = schneideLogo;
        this.team = team;
        this.homepageLink = homepageLink;
    }

    public static SchneideAboutInformation loadInformationFrom(ApplicationInformation information, File ... configurationFiles) throws IllegalArgumentException {
        ConfigurationSection[] developerSections;
        ArrayList<LocalVirtualFile> configFiles = new ArrayList<LocalVirtualFile>();
        for (File each : configurationFiles) {
            configFiles.add(new LocalVirtualFile(each));
        }
        Configuration configuration = new Configuration(configFiles);
        ArrayList<String> developersList = new ArrayList<String>();
        for (ConfigurationSection section : developerSections = configuration.getSections("developers")) {
            String[] names = StringsProperty.buildConfigured((ConfigurationPart)section, (PropertyReferenceType)PropertyReference.forKey((String)"name")).getValues();
            developersList.addAll(Arrays.asList(names));
        }
        return new SchneideAboutInformation(information, StringProperty.buildConfigured((ConfigurationPart)configuration, (PropertyReferenceType)PropertyReference.forKey((String)"application.description")).getValue(), SchneideAboutInformation.loadImageIcon(StringProperty.buildConfigured((ConfigurationPart)configuration, (PropertyReferenceType)PropertyReference.forKey((String)"application.logo")).getValue()), SchneideAboutInformation.loadImageIcon(StringProperty.buildConfigured((ConfigurationPart)configuration, (PropertyReferenceType)PropertyReference.forKeyInSection((String)"schneide", (String)"manufacturer.logo")).getValue()), StringProperty.buildConfigured((ConfigurationPart)configuration, (PropertyReferenceType)PropertyReference.forKey((String)"application.homepage.url")).getValue(), developersList.toArray(new String[developersList.size()]));
    }

    protected static ImageIcon loadImageIcon(String filePath) {
        try {
            File iconFile = FileLocator.getFile((String)filePath);
            return new ImageIcon(iconFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            Base.getDefaultLogger().error((Object)("Logo " + filePath + " konnte nicht gefunden werden."), (Throwable)e);
        }
        catch (NoSuchElementException e) {
            Base.getDefaultLogger().error((Object)("Logo " + filePath + " konnte nicht gelesen werden."), (Throwable)e);
        }
        return new ImageIcon();
    }

    @Override
    public ImageIcon getApplicationLogo() {
        return this.applicationLogo;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ApplicationInformation getInformation() {
        return this.information;
    }

    @Override
    public ImageIcon getManufacturerLogo() {
        return this.manufacturerLogo;
    }

    @Override
    public String[] getTeam() {
        return this.team;
    }

    @Override
    public String getHomepageLink() {
        return this.homepageLink;
    }
}

