/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.gui;

import com.schneide.base.application.interaction.model.InstantActionSpecification;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.layout.tablelayout.StringTableLayout;
import com.schneide.base.logging.LoggedObject;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InstantActionPanelBuilder<S extends SchneideSession<U>, U extends SchneideUser>
extends LoggedObject {
    private static final int DEFAULT_VERTICAL_GAP = 25;
    private static final Font INSTANTACTION_TITLELABEL_FONT = new Font("SansSerif", 1, 15);
    private final S session;
    private final int verticalGap;

    public InstantActionPanelBuilder(S session) {
        this(session, 25);
    }

    public InstantActionPanelBuilder(S session, int verticalGap) {
        this.session = session;
        this.verticalGap = verticalGap;
    }

    protected S getSession() {
        return this.session;
    }

    public JPanel buildInstantActionsPanel(Iterable<InstantActionSpecification<S, U>> specifications) {
        this.getLogger().debug((Object)("Building instant action panel for " + IterableUtil.getSizeFor(specifications) + " specified instant actions"));
        StringTableLayout layout = new StringTableLayout("PREFERRED, (15), 10, PREFERRED", this.getTableRowSpecification(IterableUtil.getSizeFor(specifications)));
        JPanel content = new JPanel((LayoutManager)layout);
        int current = 0;
        for (InstantActionSpecification<S, U> each : specifications) {
            JButton actionButton = new JButton(each.getAction(this.getSession()));
            actionButton.setText("");
            actionButton.setIcon(each.getIcon());
            actionButton.setToolTipText(each.getTitle());
            actionButton.setMnemonic(this.getButtonMnemonic(current));
            JLabel titleLabel = new JLabel(each.getTitle());
            titleLabel.setFont(INSTANTACTION_TITLELABEL_FONT);
            titleLabel.setOpaque(true);
            titleLabel.setBackground(titleLabel.getBackground().brighter().brighter());
            JLabel descriptionLabel = new JLabel(each.getDescription());
            int firstRow = current * 2;
            int secondRow = firstRow + 1;
            content.add("column=0, row=" + firstRow + ", rowspan=2", actionButton);
            content.add("column=1, row=" + firstRow + ", colspan=2, anchor=WEST, fill=HORIZONTAL", titleLabel);
            content.add("column=2, row=" + secondRow + ", anchor=WEST", descriptionLabel);
            ++current;
        }
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        content.setOpaque(false);
        JPanel result = new JPanel();
        result.setOpaque(false);
        result.add(content);
        return result;
    }

    private char getButtonMnemonic(int index) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(index);
        return buffer.charAt(0);
    }

    protected String getTableRowSpecification(int specificationCount) {
        StringBuilder result = new StringBuilder();
        result.append("(0)");
        for (int i = 0; i < specificationCount; ++i) {
            result.append(", PREFERRED, (5), PREFERRED, (");
            result.append(this.getVerticalGapFor(i, specificationCount));
            result.append(")");
        }
        return result.toString();
    }

    protected String getVerticalGapFor(int index, int specificationCount) {
        if (index < specificationCount - 1) {
            return String.valueOf(this.verticalGap);
        }
        return "0";
    }
}

