/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.dialog.module;

import com.schneide.base.application.module.ApplicationModule;
import com.schneide.base.application.module.ModuleMode;
import com.schneide.base.application.module.ModuleSpecification;
import com.schneide.base.application.periphery.ModuleRepository;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.icon.IconProvider;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NKeyed;
import com.schneide.base.i18n.model.I18NResolvable;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import net.java.dev.designgridlayout.DesignGridLayout;

public class ModeChangeDialog
extends AbstractSchneideDialog<Iterable<ModuleModeChange>> {
    private final ModuleRepository modules;
    private final Map<ApplicationModule<?>, JComboBox<ModuleMode>> modeSelections;

    public ModeChangeDialog(SchneideSession<? extends SchneideUser> session, ModuleRepository modules) {
        super(session.getMainWindowStack(), (I18NKeyed)new I18NKey("ModuleOverviewDialog"));
        this.modules = modules;
        this.modeSelections = new HashMap();
    }

    protected void buildUI() {
        EDT.only();
        this.addMessage(this.getTextEntry("message"));
        JPanel content = new JPanel();
        DesignGridLayout grid = new DesignGridLayout((Container)content);
        for (ApplicationModule<?> each : this.modules.all()) {
            ModuleSpecification module = each.specification();
            JLabel denotation = new JLabel(module.getDenotation());
            JLabel icon = new JLabel(module.moduleIcon().icon());
            JLabel modeTitle = new JLabel(new DirectText("Neuer Betriebsmodus:").text());
            JComboBox<ModuleMode> modeSelection = this.modeSelectionFor(module.getMode(), each);
            this.modeSelections.put(each, modeSelection);
            grid.row().grid(denotation).add(new JComponent[]{icon}).add(new JComponent[]{modeTitle}).add(new JComponent[]{modeSelection});
            grid.emptyRow();
        }
        this.setContent(content);
        this.addButton().commitCancelButtons((I18NResolvable)new DirectText("Betriebsmodi wechseln"), (I18NResolvable)new DirectText("Abbrechen"));
    }

    protected Optional<Iterable<ModuleModeChange>> giveAnswer() {
        return Optional.of(this.requiredChanges());
    }

    public Iterable<ModuleModeChange> requiredChanges() {
        ArrayList<ModuleModeChange> result = new ArrayList<ModuleModeChange>();
        for (final ApplicationModule<?> each : this.modeSelections.keySet()) {
            JComboBox<ModuleMode> selection = this.modeSelections.get(each);
            final ModuleMode selected = (ModuleMode)EDT.query(() -> (ModuleMode)selection.getSelectedItem());
            ModuleMode current = each.specification().getMode();
            if (current.equals((Object)selected)) continue;
            result.add(new ModuleModeChange(){

                @Override
                public ModuleMode newMode() {
                    return selected;
                }

                @Override
                public ApplicationModule<?> module() {
                    return each;
                }
            });
        }
        return result;
    }

    private JComboBox<ModuleMode> modeSelectionFor(ModuleMode current, ApplicationModule<?> module) {
        JComboBox<ModuleMode> result = new JComboBox<ModuleMode>();
        result.setRenderer(new ModuleModeRenderer(current, module));
        module.factory().getAvailableModes().forEach(mode -> result.addItem((ModuleMode)mode));
        result.setSelectedItem(current);
        return result;
    }

    private class ModuleModeRenderer
    extends JLabel
    implements ListCellRenderer<ModuleMode> {
        private static final long serialVersionUID = -1716993546239634619L;
        private final ModuleMode preselection;
        private final ApplicationModule<?> module;

        public ModuleModeRenderer(ModuleMode preselection, ApplicationModule<?> module) {
            this.preselection = preselection;
            this.module = module;
            this.setOpaque(true);
            this.setHorizontalAlignment(10);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ModuleMode> list, ModuleMode value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setIcon(((IconProvider)value.modeIcon().apply((Object)this.module.specification().getIdentifier())).icon());
            this.setText(this.descriptionOf(value));
            return this;
        }

        private String descriptionOf(ModuleMode value) {
            StringBuilder result = new StringBuilder();
            result.append(value.getDenotation());
            if (this.preselection.equals((Object)value)) {
                result.append(new DirectText(" (in Verwendung)").text());
            }
            return result.toString();
        }
    }

    public static interface ModuleModeChange {
        public ApplicationModule<?> module();

        public ModuleMode newMode();
    }
}

