/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.dialog;

import com.schneide.base.application.SchneideApplication;
import com.schneide.base.application.crypt.EncryptionException;
import com.schneide.base.application.dialog.LoginCredentialProvider;
import com.schneide.base.application.usermanagement.crypto.Password;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.layout.StringGridBagLayout;
import com.schneide.base.system.Base;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.java.dev.designgridlayout.DesignGridLayout;
import nl.jj.swingx.gui.modal.JModalFrame;

public class LoginFrame
extends JModalFrame
implements FocusListener,
LoginCredentialProvider {
    private static final long serialVersionUID = 6313342311684236706L;
    public static final String FRAME_NAME = "LoginFrame";
    public static final String FIELD_USERNAME = "textfield.username";
    public static final String FIELD_PASSWORD = "textfield.password";
    public static final String BUTTON_LOGIN = "button.login";
    private static final String CMD_CANCEL = "cmd.cancel";
    private static final String CMD_SHUTDOWN = "cmd.shutdown";
    private static final String CMD_LOGIN = "cmd.login";
    private JButton loginButton;
    private JButton cancelButton;
    private JButton shutdownButton;
    private final JTextField userNameTextField = new JTextField();
    private final JPasswordField passwordTextField = new JPasswordField();
    private boolean isCancelled;
    private boolean isShutdown;

    public LoginFrame(SchneideApplication application) {
        this(application, "");
    }

    public LoginFrame(SchneideApplication application, String message) {
        super(true);
        this.setIconImage(application.getIcon().getImage());
        this.setName(FRAME_NAME);
        this.initComponents(application, message);
        this.pack();
        this.centerWindow();
    }

    private void centerWindow() {
        Rectangle screen = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        Point center = new Point((int)screen.getCenterX(), (int)screen.getCenterY());
        Point newLocation = new Point(center.x - this.getWidth() / 2, center.y - this.getHeight() / 2);
        if (screen.contains(newLocation.x, newLocation.y, this.getWidth(), this.getHeight())) {
            this.setLocation(newLocation);
        }
    }

    protected JLabel createUserNameLabel() {
        JLabel userNameLabel = new JLabel();
        userNameLabel.setDisplayedMnemonic('B');
        userNameLabel.setLabelFor(this.userNameTextField);
        userNameLabel.setText(new I18NKey("LoginFrame.username.title").resolvedText() + ":");
        return userNameLabel;
    }

    protected JLabel createPasswordLabel() {
        JLabel passwordLabel = new JLabel();
        passwordLabel.setDisplayedMnemonic('P');
        passwordLabel.setLabelFor(this.passwordTextField);
        passwordLabel.setText(new I18NKey("LoginFrame.password.title").resolvedText() + ":");
        return passwordLabel;
    }

    private void initComponents(SchneideApplication application, String message) {
        this.setTitle(Base.getTextContent().getParametrizedText("LoginFrame.title", new Object[]{application.getName()}));
        this.setResizable(false);
        this.addWindowListener(new CancelOnCloseWindowAdapter());
        this.getAccessibleContext().setAccessibleDescription("Login Dialog");
        this.layoutContent(this.getContentPane(), application, message);
        this.equalizeButtonSizes();
        this.setDefaultCloseOperation(0);
    }

    protected void layoutContent(Container content, SchneideApplication application, String message) {
        content.setLayout(new BorderLayout());
        content.add((Component)this.createSplashLabel(application), "North");
        JPanel widgetPanel = new JPanel();
        widgetPanel.setLayout((LayoutManager)new StringGridBagLayout());
        JLabel messageLabel = new JLabel(message);
        messageLabel.setForeground(Color.RED);
        widgetPanel.add("gridx=0,gridy=0,anchor=CENTER,gridwidth=2,insets=[12,12,0,0]", messageLabel);
        widgetPanel.add("gridx=0,gridy=1,anchor=WEST,insets=[12,12,0,0]", this.createUserNameLabel());
        this.userNameTextField.setName(FIELD_USERNAME);
        this.userNameTextField.addActionListener(new PasswordTextFieldRequestFocusActionListener());
        widgetPanel.add("gridx=1,gridy=1,fill=HORIZONTAL,weightx=1.0,insets=[12,7,0,11]", this.userNameTextField);
        widgetPanel.add("gridx=0,gridy=2,anchor=WEST,insets=[12,12,0,0]", this.createPasswordLabel());
        this.passwordTextField.setName(FIELD_PASSWORD);
        this.passwordTextField.setEchoChar('\u2022');
        this.passwordTextField.addFocusListener(this);
        widgetPanel.add("gridx=1,gridy=2,fill=HORIZONTAL,weightx=1.0,insets=[11,7,0,11]", this.passwordTextField);
        this.loginButton = this.createLoginButton();
        this.cancelButton = this.createCancelButton();
        this.shutdownButton = this.createShutdownButton();
        JPanel buttonPanel = new JPanel();
        DesignGridLayout layout = new DesignGridLayout((Container)buttonPanel);
        layout.row().grid().add(new JComponent[]{this.loginButton}).add(new JComponent[]{this.cancelButton}).add(new JComponent[]{this.shutdownButton});
        widgetPanel.add("gridx=0,gridy=3,gridwidth=4,fill=HORIZONTAL,insets=[17,11,11,11]", buttonPanel);
        content.add((Component)widgetPanel, "Center");
    }

    protected JButton createLoginButton() {
        JButton result = new JButton();
        result.setName(BUTTON_LOGIN);
        result.setText(new I18NKey("LoginFrame.button.login.title").resolvedText());
        result.setActionCommand(CMD_LOGIN);
        result.addActionListener(new DialogDoneActionListener());
        return result;
    }

    protected JButton createCancelButton() {
        JButton result = new JButton();
        result.setText(new I18NKey("LoginFrame.button.cancel.title").resolvedText());
        result.setActionCommand(CMD_CANCEL);
        result.addActionListener(new DialogDoneActionListener());
        return result;
    }

    protected JButton createShutdownButton() {
        JButton result = new JButton();
        result.setText(new I18NKey("LoginFrame.button.shutdown.title").resolvedText());
        result.setActionCommand(CMD_SHUTDOWN);
        result.addActionListener(new DialogDoneActionListener());
        return result;
    }

    protected JPanel createSplashLabel(SchneideApplication application) {
        JPanel result = new JPanel(new BorderLayout());
        JLabel splashLabel = new JLabel();
        splashLabel.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
        splashLabel.setIcon(application.getAboutInformation().getApplicationLogo());
        splashLabel.setHorizontalAlignment(0);
        splashLabel.setHorizontalTextPosition(0);
        JLabel anwendungstitel = new JLabel(application.getName());
        anwendungstitel.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
        anwendungstitel.setFont(anwendungstitel.getFont().deriveFont(24.0f));
        anwendungstitel.setHorizontalAlignment(0);
        anwendungstitel.setHorizontalTextPosition(0);
        result.add((Component)splashLabel, "North");
        result.add(Box.createVerticalStrut(20), "Center");
        result.add((Component)anwendungstitel, "South");
        return result;
    }

    private void equalizeButtonSizes() {
        int i;
        JButton[] buttons = new JButton[]{this.loginButton, this.cancelButton, this.shutdownButton};
        String[] labels = new String[buttons.length];
        for (i = 0; i < labels.length; ++i) {
            labels[i] = buttons[i].getText();
        }
        i = 0;
        Dimension maxSize = new Dimension(0, 0);
        Rectangle2D textBounds = null;
        FontMetrics metrics = buttons[0].getFontMetrics(buttons[0].getFont());
        Graphics g = this.getGraphics();
        for (i = 0; i < labels.length; ++i) {
            textBounds = metrics.getStringBounds(labels[i], g);
            maxSize.width = Math.max(maxSize.width, (int)textBounds.getWidth());
            maxSize.height = Math.max(maxSize.height, (int)textBounds.getHeight());
        }
        Insets insets = buttons[0].getBorder().getBorderInsets(buttons[0]);
        maxSize.width += insets.left + insets.right;
        maxSize.height += insets.top + insets.bottom;
        for (i = 0; i < buttons.length; ++i) {
            buttons[i].setPreferredSize((Dimension)maxSize.clone());
            buttons[i].setMaximumSize((Dimension)maxSize.clone());
        }
    }

    protected void dialogDone(Object actionCommand) {
        String cmd = null;
        if (actionCommand != null) {
            cmd = actionCommand instanceof ActionEvent ? ((ActionEvent)actionCommand).getActionCommand() : actionCommand.toString();
        }
        if (null == cmd) {
            return;
        }
        if (cmd.equals(CMD_CANCEL)) {
            this.isCancelled = true;
        } else if (cmd.equals(CMD_SHUTDOWN)) {
            this.isCancelled = true;
            this.isShutdown = true;
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public String getUserName() {
        return (String)EDT.query(() -> this.userNameTextField.getText());
    }

    @Override
    public Password getPassword() {
        String clearText = (String)EDT.query(() -> new String(this.passwordTextField.getPassword()));
        try {
            return Password.fromPlaintext(clearText);
        }
        catch (EncryptionException e) {
            Base.getLogger((Object)this).fatal((Object)"Cannot encrypt user-provided password. Aborting.", (Throwable)e);
            return null;
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.getRootPane().setDefaultButton(this.loginButton);
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (new String(this.passwordTextField.getPassword()).length() < 1) {
            this.getRootPane().setDefaultButton(null);
        }
    }

    protected void focusOnPasswordField() {
        this.passwordTextField.requestFocus();
    }

    private class CancelOnCloseWindowAdapter
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent event) {
            LoginFrame.this.dialogDone(LoginFrame.CMD_CANCEL);
        }
    }

    private class PasswordTextFieldRequestFocusActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            LoginFrame.this.focusOnPasswordField();
        }
    }

    private class DialogDoneActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            LoginFrame.this.dialogDone(event);
        }
    }
}

