/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.data;

import com.schneide.base.application.data.MutableEmail;
import com.schneide.base.datatypes.collections.CollectionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GenericEmail
implements MutableEmail {
    private final List<File> attachmentList = new ArrayList<File>();
    private final List<String> recipientList;
    private String sender;
    private String subject;
    private String message;

    public GenericEmail(String sender) {
        this(sender, new String[0], "", "", new File[0]);
    }

    public GenericEmail(String sender, String recipient, String subject, String message) {
        this(sender, recipient, subject, message, new File[0]);
    }

    public GenericEmail(String sender, String recipient, String subject, String message, File ... attachments) {
        this(sender, new String[]{recipient}, subject, message, attachments);
    }

    public GenericEmail(String sender, String[] recipients, String subject, String message, File ... attachments) {
        this.attachmentList.addAll(Arrays.asList(attachments));
        this.recipientList = new ArrayList<String>();
        this.recipientList.addAll(Arrays.asList(recipients));
        this.sender = sender;
        this.subject = subject;
        this.message = message;
    }

    @Override
    public void addAttachment(File file) {
        this.addAttachments(new File[]{file});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAttachments(File[] files) {
        List<File> list = this.attachmentList;
        synchronized (list) {
            this.attachmentList.addAll(Arrays.asList(files));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAttachments(Iterable<File> files) {
        List<File> list = this.attachmentList;
        synchronized (list) {
            CollectionUtil.addAll(this.attachmentList, files);
        }
    }

    @Override
    public void addRecipient(String recipientAddress) {
        this.addRecipients(new String[]{recipientAddress});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRecipients(String[] recipientAddresses) {
        List<String> list = this.recipientList;
        synchronized (list) {
            this.recipientList.addAll(Arrays.asList(recipientAddresses));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRecipients(Iterable<String> recipientAddresses) {
        List<String> list = this.recipientList;
        synchronized (list) {
            CollectionUtil.addAll(this.recipientList, recipientAddresses);
        }
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] getAttachment() {
        List<File> list = this.attachmentList;
        synchronized (list) {
            return this.attachmentList.toArray(new File[this.attachmentList.size()]);
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getRecipients() {
        List<String> list = this.recipientList;
        synchronized (list) {
            return this.recipientList.toArray(new String[this.recipientList.size()]);
        }
    }

    @Override
    public String getSender() {
        return this.sender;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public boolean hasRecipients() {
        return this.getRecipients().length > 0;
    }

    @Override
    public void setSender(String senderAddress) {
        this.sender = senderAddress;
    }
}

