/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.crud.gui;

import com.schneide.base.application.crud.CrudElement;
import com.schneide.base.application.crud.CrudModel;
import com.schneide.base.application.crud.CrudModelChangeListener;
import com.schneide.base.application.crud.DisplayInformationProvider;
import com.schneide.base.gui.component.SortableTableModel;
import com.schneide.base.gui.swing.EDT;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class GenericElementTableModel<E extends CrudElement<I>, I>
extends AbstractTableModel
implements SortableTableModel,
CrudModelChangeListener {
    private static final long serialVersionUID = 807487416416777498L;
    private final CrudModel<E, I> model;
    private final DisplayInformationProvider<E, I> displayInformation;
    private ColumnSortComparator comparator;

    public GenericElementTableModel(CrudModel<E, I> model, DisplayInformationProvider<E, I> valueMapper) {
        this.model = model;
        this.displayInformation = valueMapper;
        this.sortColumn(0, true);
    }

    @Override
    public void modelChanged() {
        EDT.later(() -> this.fireTableDataChanged());
    }

    public void sortColumn(int columnIndex, boolean ascending) {
        this.comparator = new ColumnSortComparator(columnIndex, ascending);
    }

    @Override
    public int getColumnCount() {
        return this.displayInformation.getValueDenotations().length;
    }

    @Override
    public String getColumnName(int column) {
        return this.displayInformation.getValueDenotations()[column];
    }

    @Override
    public int getRowCount() {
        return this.getAllEntries().length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.displayInformation.getValuesFor(this.getElementAt(rowIndex))[columnIndex];
    }

    public E getElementAt(int index) {
        return (E)((CrudElement)this.getSortedEntries().get(index));
    }

    public List<E> getSortedEntries() {
        ArrayList sortedList = new ArrayList();
        Collections.addAll(sortedList, this.getAllEntries());
        Collections.sort(sortedList, this.comparator);
        return sortedList;
    }

    public E[] getAllEntries() {
        return this.model.getAllElements();
    }

    public DisplayInformationProvider<E, I> getDisplayInformation() {
        return this.displayInformation;
    }

    private class ColumnSortComparator
    implements Comparator<E>,
    Serializable {
        private static final long serialVersionUID = 6997820543378872368L;
        private final int sortColumn;
        private final int sortDirection;

        protected ColumnSortComparator(int sortColumn, boolean ascending) {
            this.sortColumn = sortColumn;
            this.sortDirection = this.getDirection(ascending);
        }

        private int getDirection(boolean isAscending) {
            if (isAscending) {
                return 1;
            }
            return -1;
        }

        @Override
        public int compare(E o1, E o2) {
            Comparable<?> c1 = GenericElementTableModel.this.getDisplayInformation().getValuesFor(o1)[this.sortColumn];
            Comparable<?> c2 = GenericElementTableModel.this.getDisplayInformation().getValuesFor(o2)[this.sortColumn];
            return this.sortDirection * c1.compareTo(c2);
        }
    }
}

