/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.crud.gui;

import com.schneide.base.application.crud.CreationException;
import com.schneide.base.application.crud.CrudElement;
import com.schneide.base.application.crud.CrudModel;
import com.schneide.base.application.crud.ValueMapper;
import com.schneide.base.application.crud.gui.CreationDialog;
import com.schneide.base.application.crud.gui.UpdateDialog;
import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NKeyed;
import com.schneide.base.input.helper.LayoutHelper;
import com.schneide.base.input.inputs.InputFactory;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.inputs.layout.DefaultMigLayoutStrategy;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.types.generic.Value;
import java.awt.LayoutManager;
import java.util.Optional;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class GenericCreationAndUpdateDialog<E extends CrudElement<I>, I>
extends AbstractSchneideDialog<E>
implements UpdateDialog<E, I>,
CreationDialog<E, I> {
    private E element;
    private final ValueMapper<E, I> valueMapper;
    private final Value[] mappedValues;
    private final InputFactory factory;
    private CrudModel<E, I> model;

    public GenericCreationAndUpdateDialog(WindowStack session, I18NKey baseKey, InputFactory factory, E element, ValueMapper<E, I> valueMapper) {
        super(session, (I18NKeyed)baseKey);
        this.factory = factory;
        this.element = element;
        this.valueMapper = valueMapper;
        this.mappedValues = this.valueMapper.getValuesFor(this.element);
    }

    public GenericCreationAndUpdateDialog(WindowStack session, I18NKey baseKey, InputFactory factory, CrudModel<E, I> model, ValueMapper<E, I> valueMapper) {
        super(session, (I18NKeyed)baseKey);
        this.factory = factory;
        this.model = model;
        this.valueMapper = valueMapper;
        this.mappedValues = this.valueMapper.getGenericValues();
    }

    @Override
    public E createElement() throws CreationException {
        this.element = this.model.createElement();
        this.updateElement();
        return this.element;
    }

    protected Optional<E> giveAnswer() {
        return Optional.ofNullable(this.getElement());
    }

    @Override
    public E getElement() {
        return this.element;
    }

    @Override
    public void updateElement() {
        this.valueMapper.update(this.getElement(), this.mappedValues);
    }

    protected void buildUI() {
        Input[] inputs = new Input[this.mappedValues.length];
        for (int i = 0; i < this.mappedValues.length; ++i) {
            inputs[i] = this.mappedValues[i].createNaturalInput(this.factory);
        }
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "[][fill, grow][]", ""));
        LayoutHelper.addToPanel((JPanel)panel, (LayoutStrategy)new DefaultMigLayoutStrategy(), (Input[])inputs);
        panel.setOpaque(true);
        this.setContent(panel);
        this.addButton().commitCancelButtons();
    }
}

