/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.configuration.implementation;

import com.schneide.base.configuration.SecureConfiguration;
import com.schneide.base.gui.splash.SplashConfiguration;
import com.schneide.base.system.Base;
import java.awt.Point;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class SplashPropertiesProxy
extends SecureConfiguration
implements SplashConfiguration {
    public SplashPropertiesProxy(File propertiesFile) {
        super(propertiesFile, "Einstellungen f\u00fcr Startfenster");
    }

    public File getImageFile() {
        return this.getFileProperty("splashscreen.image", "resources/images/logos/splashscreen.png");
    }

    public URL getImageResource() {
        try {
            return this.getImageFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            Base.getLogger((Object)((Object)this)).error((Object)"The given image file URL is not valid.", (Throwable)e);
            return null;
        }
    }

    public String getTitleInitialText() {
        return this.getStringProperty("splashscreen.title.initialText", "Starte Anwendung...");
    }

    public boolean canReplaceTitle() {
        return this.getBooleanProperty("splashscreen.title.replaceAllowed", true);
    }

    public Point getBootMessagePosition() {
        int column = this.getIntegerProperty("splashscreen.message.position.horizontal[pixel]", 30);
        int row = this.getIntegerProperty("splashscreen.message.position.vertical[pixel]", 475);
        return new Point(column, row);
    }

    public boolean isBootMessagesEnabled() {
        return true;
    }
}

