/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application;

import com.schneide.base.application.ApplicationEngine;
import com.schneide.base.application.ApplicationInformation;
import com.schneide.base.application.SchneideApplication;
import com.schneide.base.application.configuration.SystemConfiguration;
import com.schneide.base.application.configuration.implementation.SplashPropertiesProxy;
import com.schneide.base.application.gui.about.AboutInformation;
import com.schneide.base.application.gui.about.SchneideAboutInformation;
import com.schneide.base.application.gui.ux.KeyboardUX;
import com.schneide.base.application.handler.ShutdownHandler;
import com.schneide.base.application.loaders.VersionInfoFileLoader;
import com.schneide.base.application.login.LoginHandler;
import com.schneide.base.application.login.LogoutHandler;
import com.schneide.base.application.management.NewsReceivers;
import com.schneide.base.application.module.GenericModuleEngine;
import com.schneide.base.application.module.ModuleCreator;
import com.schneide.base.application.module.ModulesConfiguration;
import com.schneide.base.application.module.creation.ConfigurableModuleCreationInformation;
import com.schneide.base.application.module.creation.ModuleCreationInformation;
import com.schneide.base.application.module.internal.InformedModuleCreator;
import com.schneide.base.application.problem.ProblemDialogDisplayer;
import com.schneide.base.application.process.autoexecution.AutoProcessExecutor;
import com.schneide.base.application.process.boot.BootProcessExecutor;
import com.schneide.base.application.process.cron.CronJobTimeoutSupervisor;
import com.schneide.base.application.process.cron.CronProcessAdjuster;
import com.schneide.base.application.process.cron.CronProcessExecutionSpecification;
import com.schneide.base.application.process.cron.CronProcessProblemSubject;
import com.schneide.base.application.process.cron.CronProcessStarter;
import com.schneide.base.application.process.cron.GenericSchneideProcessJobProvider;
import com.schneide.base.application.process.cron.ProcessJobProvider;
import com.schneide.base.application.process.cron.management.ProcessManager;
import com.schneide.base.application.selection.CronProcessSelectorDialog;
import com.schneide.base.application.selection.ProcessExecutionSelection;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.session.UserInformationProvider;
import com.schneide.base.application.session.UserListener;
import com.schneide.base.application.shutdown.ApplicationShutdown;
import com.schneide.base.application.shutdown.RestartTarget;
import com.schneide.base.application.startup.news.AnwendungVollst\u00e4ndigGestartet;
import com.schneide.base.application.topicality.UpdateHandler;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.right.RightChecker;
import com.schneide.base.application.version.Version;
import com.schneide.base.datatypes.collections.ArrayUtil;
import com.schneide.base.datatypes.collections.iterable.UpcastingIterable;
import com.schneide.base.datatypes.exceptions.RegardingExceptions;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.News;
import com.schneide.base.eventbus.internal.ProcessingTimeSupervisedThreadedEventBus;
import com.schneide.base.eventbus.internal.ThreadedEventBus;
import com.schneide.base.eventbus.stopper.StopLifecycledReceivers;
import com.schneide.base.gui.icon.IconLoader;
import com.schneide.base.gui.splash.BootMessageLogger;
import com.schneide.base.gui.splash.NoSchneideSplash;
import com.schneide.base.gui.splash.PlatformSchneideSplash;
import com.schneide.base.gui.splash.SchneideSplash;
import com.schneide.base.gui.splash.SplashConfiguration;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.i18n.DefaultSchneideI18NSetup;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.I18NText;
import com.schneide.base.i18n.NotI18NYet;
import com.schneide.base.i18n.implementation.FileI18NConfiguration;
import com.schneide.base.i18n.model.I18NConfiguration;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.io.virtual.wrapper.DeveloperOverdrive;
import com.schneide.base.lifecycle.LifeCycle;
import com.schneide.base.lifecycle.dependent.DisposeDependentResources;
import com.schneide.base.listener.ListenerContainer;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.logging.LoggerFactory;
import com.schneide.base.logging.exception.LoggingExceptionHandler;
import com.schneide.base.logging.implementation.SchneideLoggerFactory;
import com.schneide.base.properties.userLevel.SuffixProvider;
import com.schneide.base.system.Base;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import com.schneide.base.timing.DelayMeasurer;
import com.schneide.base.util.Parameter;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.swing.ImageIcon;

public abstract class AbstractApplication<S extends SchneideSession<U>, U extends SchneideUser>
extends LoggedObject
implements SchneideApplication,
ShutdownHandler<S>,
LogoutHandler<S>,
UserInformationProvider {
    private static final String BOOT_MESSAGE = "***** Booting Application";
    protected static final long MAXIMUM_NEWS_PROCESSING_TIME_MILLISECONDS = 1000L;
    private DelayMeasurer startupTimeMeasurer;
    private SchneideSplash splashScreen;
    private String name;
    private Version version;
    private ImageIcon icon;
    private SystemConfiguration systemConfiguration;
    private AboutInformation aboutInformation;
    private ApplicationEngine<S, U> applicationEngine;
    private ListenerContainer<UserListener> sessionStateListeners;
    private CronProcessStarter cronStarter;
    private ModulesConfiguration modulesConfiguration;
    private final ApplicationShutdown shutdown;
    private final CronProcessProblemSubject cronProblemSubject;
    private final EventBus applicationBus;
    private final List<LifeCycle> dependentResources;
    private boolean isFullyBuilt;
    private ModuleCreator moduleCreator;

    protected AbstractApplication(ApplicationShutdown shutdown, VirtualFile versionInfoFile, SystemConfiguration systemConfiguration) {
        this(shutdown, new VersionInfoFileLoader(versionInfoFile), systemConfiguration);
    }

    protected AbstractApplication(ApplicationShutdown shutdown, VersionInfoFileLoader versionInfo, SystemConfiguration systemConfiguration) {
        this(shutdown, versionInfo.getApplicationName(), versionInfo.getVersion(), systemConfiguration);
    }

    protected AbstractApplication(ApplicationShutdown shutdown, String name, Version version, SystemConfiguration systemConfiguration) {
        this.shutdown = shutdown;
        this.startupTimeMeasurer = new DelayMeasurer();
        Base.logOnConsole((String)BOOT_MESSAGE);
        this.name = name;
        this.version = version;
        this.systemConfiguration = systemConfiguration;
        this.sessionStateListeners = new ListenerContainer();
        this.dependentResources = new ArrayList<LifeCycle>();
        this.setupBaseSystem(systemConfiguration);
        this.noteApplicationStartInJournal();
        this.icon = this.loadIcon();
        this.splashScreen = this.buildVisibleSplashScreen(systemConfiguration);
        this.showBootMessage("start");
        RightChecker.setGUIMode(RightChecker.GUIMode.USER_DIALOG);
        this.cronProblemSubject = new CronProcessProblemSubject();
        this.applicationBus = this.createStartedEventBusInstance();
        this.isFullyBuilt = false;
    }

    protected void noteApplicationStartInJournal() {
        String versionsinformation = this.version.denotation() + " (Build " + this.version.build().id() + ")";
        String logEntry = "Anwendung " + this.name + " startet in Version " + versionsinformation;
        this.getLogger().info((Object)logEntry);
    }

    protected EventBus createStartedEventBusInstance() {
        ThreadedEventBus result = this.createEventBusInstance();
        result.start();
        this.addDependent((LifeCycle)result);
        return result;
    }

    protected ThreadedEventBus createEventBusInstance() {
        return new ProcessingTimeSupervisedThreadedEventBus(1000L, (ThreadedEventBus.StopProcedure)new StopLifecycledReceivers(), this.systemConfiguration::isNewsLoggingForced, this.systemConfiguration::isNewsLoggingEnabled);
    }

    protected void registerUncaughtExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        Thread.setDefaultUncaughtExceptionHandler(exceptionHandler);
        System.setProperty("sun.awt.exception.handler", exceptionHandler.getClass().getName());
    }

    private void setupBaseSystem(SystemConfiguration systemProperties) {
        this.setupBaseServices(systemProperties);
    }

    protected ApplicationShutdown getShutdown() {
        return this.shutdown;
    }

    protected ImageIcon loadIcon() {
        return (ImageIcon)EDT.query(() -> IconLoader.loadIcon((File)this.systemConfiguration.getIconFile()));
    }

    private SchneideSplash buildVisibleSplashScreen(SystemConfiguration systemProperties) {
        PlatformSchneideSplash result;
        SplashPropertiesProxy splashConfiguration = new SplashPropertiesProxy(systemProperties.getSplashScreenConfigurationFile());
        if (PlatformSchneideSplash.isActive()) {
            result = new PlatformSchneideSplash((SplashConfiguration)splashConfiguration);
        } else if (systemProperties.isSplashscreenEnabled()) {
            this.getLogger().warn((Object)"Using no splash instead of not yet implemented java splash.");
            result = new NoSchneideSplash((SplashConfiguration)splashConfiguration);
        } else {
            result = new NoSchneideSplash((SplashConfiguration)splashConfiguration);
        }
        return result;
    }

    protected void setupLogging() {
        Base.setCurrentLoggerFactory((LoggerFactory)new SchneideLoggerFactory());
    }

    protected void setupExceptionHandler() {
        this.registerUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new LoggingExceptionHandler());
    }

    protected void setupI18N(SystemConfiguration i18nConfiguration) {
        DefaultSchneideI18NSetup.setupFor((I18NConfiguration)new FileI18NConfiguration((VirtualFile)DeveloperOverdrive.of((VirtualFile)new LocalVirtualFile(i18nConfiguration.getI18NConfigurationFile()))));
    }

    protected void setupLookAndFeel(SystemConfiguration lookAndFeelConfiguration) {
        Parameter.isPresent((Object)lookAndFeelConfiguration);
        KeyboardUX.enableModernFocusTraversal();
    }

    protected void setupBaseServices(SystemConfiguration servicesConfiguration) {
        this.setupLogging();
        this.setupExceptionHandler();
        this.setupI18N(servicesConfiguration);
        this.setupLookAndFeel(servicesConfiguration);
    }

    @Override
    public final synchronized AboutInformation getAboutInformation() {
        if (this.aboutInformation == null) {
            this.aboutInformation = SchneideAboutInformation.loadInformationFrom(this, this.getSystemConfiguration().getTeamCreditFile(), this.getSystemConfiguration().getApplicationConfigurationFile());
        }
        return this.aboutInformation;
    }

    protected UpdateHandler provideUpdateHandler() {
        return () -> {};
    }

    public final void boot() {
        try {
            this.buildPreFrameworkResources();
            this.showBootMessage("framework");
            this.buildFramework();
            this.showBootMessage("application");
            this.isFullyBuilt = this.build();
            this.showBootMessage("execution");
            this.startBootExecution();
            this.showBootMessage("server");
            this.startBackgroundServers();
            this.registerManagementBeans();
            this.showBootMessage("done");
            this.removeSplashScreen();
            this.startCronExecution(this.createSystemSession());
            this.firstMinuteActions();
            this.getApplicationBus().publish((News)AnwendungVollst\u00e4ndigGestartet.jetzt((Duration)Duration.ofMillis(this.startupTimeMeasurer.getMillisecondDelay())));
            this.startUserDependentApplication();
        }
        catch (Exception e) {
            this.getLogger().fatal((Object)new NotI18NYet("Unable to boot application.", new Object[0]), (Throwable)e);
        }
    }

    protected abstract void firstMinuteActions();

    protected final void showBootMessage(String i18nKeyPart) {
        this.showBootMessage((I18NResolvable)new I18NKey("boot.message").withKeyPart(i18nKeyPart));
    }

    protected final void showBootMessage(I18NResolvable message) {
        this.splashScreen.logBootMessage(message.resolvedText());
    }

    private void removeSplashScreen() {
        this.splashScreen.remove();
        this.startupTimeMeasurer.stop();
        this.getLogger().info((Object)(this.getDescription() + " startet in " + this.startupTimeMeasurer.getReadableShowtime() + "."));
    }

    protected void startBackgroundServers() {
    }

    @Override
    public EventBus getApplicationBus() {
        return this.applicationBus;
    }

    private void startUserDependentApplication() {
        S currentSession = this.performLogin();
        this.start(currentSession);
        this.startAutoExecution(currentSession);
        this.notifyLoginPerformed(currentSession);
    }

    protected void stopUserDependentApplication(S currentSession) {
        currentSession.destroyVisualContent();
        this.stopResourcesBoundTo(currentSession);
        this.getAbstractApplicationEngine().getSessionHandler().endSession(currentSession);
        currentSession.stop();
        this.notifyLogoutPerformed(currentSession);
    }

    protected abstract void stopResourcesBoundTo(S var1);

    @Override
    public void addUserListener(UserListener listener) {
        this.sessionStateListeners.addListener((Object)listener);
    }

    @Override
    public void removeUserListener(UserListener listener) {
        this.sessionStateListeners.removeListener((Object)listener);
    }

    private void notifyLogoutPerformed(S currentSession) {
        for (UserListener listener : this.sessionStateListeners.getListeners()) {
            listener.notifyLogoutPerformed((SchneideUser)currentSession.getUser());
        }
    }

    private void notifyLoginPerformed(S currentSession) {
        for (UserListener listener : this.sessionStateListeners.getListeners()) {
            listener.notifyLoginPerformed((SchneideUser)currentSession.getUser());
        }
    }

    @Override
    public void performLogout(S currentSession) {
        this.stopUserDependentApplication(currentSession);
        this.startUserDependentApplication();
    }

    private S performLogin() {
        LoginHandler<U> handler = this.createLoginHandler();
        U user = handler.performLogin(this.getAbstractApplicationEngine().getUserManager(), this);
        S result = this.getAbstractApplicationEngine().getSessionHandler().createSessionFor(user, this.getApplicationEngine().getUserManager(), this, this.getAbstractApplicationEngine().getActionManager());
        result.start();
        return result;
    }

    @Override
    public abstract void shutdownApplication(S var1) throws IllegalAccessException;

    protected abstract LoginHandler<U> createLoginHandler();

    private void startBootExecution() {
        BootProcessExecutor executor = new BootProcessExecutor((VirtualFile)DeveloperOverdrive.of((VirtualFile)new LocalVirtualFile(this.getSystemConfiguration().getBootExecutionConfigurationFile())));
        executor.execute(this.getAbstractApplicationEngine());
    }

    protected void startCronExecution(S session) {
        this.cronStarter = new CronProcessStarter((VirtualFile)DeveloperOverdrive.of((VirtualFile)new LocalVirtualFile(this.getSystemConfiguration().getCronexecutionConfigurationFile())), this.buildProcessJobProvider(session), (CronJobTimeoutSupervisor.NoCronThreadsAvailableProblemHandler)this.cronProblemSubject);
        this.cronStarter.start();
        this.addDependent(this.cronStarter);
        this.cronStarter.scheduleProcessesFor(this.retrieveCronExecutionSelections(this.cronStarter.getCronProcessSpecifications()));
        ProcessManager processManager = this.cronStarter.createProcessManager();
        processManager.start();
        this.getAbstractApplicationEngine().getProcessContextHandler().registerProcessContextObject(processManager);
    }

    protected CronProcessProblemSubject getCronProblemSubject() {
        return this.cronProblemSubject;
    }

    protected ProcessJobProvider buildProcessJobProvider(S session) {
        return new GenericSchneideProcessJobProvider<S, U>(this.getAbstractApplicationEngine().getActionManager(), session);
    }

    private Iterable<ProcessExecutionSelection> retrieveCronExecutionSelections(CronProcessExecutionSpecification[] specifications) {
        if (this.getSystemConfiguration().getSelectCronProcessesSchedulingState() && ArrayUtil.hasContent((Object[])specifications)) {
            CronProcessSelectorDialog dialog = new CronProcessSelectorDialog(this.createSystemSession().getMainWindowStack(), specifications);
            return dialog.showDialog().orElseGet(Collections::emptyList);
        }
        return Collections.emptyList();
    }

    private void startAutoExecution(S systemSession) {
        AutoProcessExecutor<S, U> executor = new AutoProcessExecutor<S, U>((VirtualFile)DeveloperOverdrive.of((VirtualFile)new LocalVirtualFile(this.getSystemConfiguration().getAutoexecutionConfigurationFile())));
        executor.execute(this.getAbstractApplicationEngine(), systemSession);
    }

    protected void buildPreFrameworkResources() {
    }

    private void buildFramework() {
        this.applicationEngine = this.buildApplicationEngine();
        this.addDependent(this.applicationEngine);
        new ProblemDialogDisplayer().subscribeTo(this.getApplicationBus());
    }

    protected abstract ApplicationEngine<S, U> buildApplicationEngine();

    public final ApplicationEngine<S, U> getAbstractApplicationEngine() {
        return this.applicationEngine;
    }

    protected final void performDefaultShutdown(S session) {
        try {
            if (session != null) {
                this.getLogger().info((Object)("The user " + session.getUser().getLogIn() + " stopped application " + this.getName()));
                this.stopUserDependentApplication(session);
            }
            this.lastMinuteActions();
            this.stop();
            this.cleanup();
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error while performing default shutdown.", (Throwable)e);
        }
        finally {
            this.shutdown.shutdownApplication();
        }
    }

    protected void lastMinuteActions() {
    }

    @Override
    public final void adjustCronProcesses(CronProcessAdjuster adjuster) {
        if (null == adjuster) {
            return;
        }
        adjuster.adjustFor(this.cronStarter.getScheduler(), this.cronStarter.getCronTriggers());
    }

    private boolean build() {
        RegardingExceptions<Boolean, RuntimeException> withHandledErrors = new RegardingExceptions<Boolean, RuntimeException>(){

            protected Boolean ifSomethingGoesWrongHere() {
                return AbstractApplication.this.buildInternally();
            }

            protected RuntimeException thenHandle(Throwable t) {
                if (t instanceof Error) {
                    Error error = (Error)t;
                    AbstractApplication.this.reactOnErrorsDuringBuild(error);
                    throw error;
                }
                throw new RuntimeException("Error during bootup of application.", t);
            }

            protected Boolean fallbackResult() {
                return false;
            }
        };
        return (Boolean)withHandledErrors.perform();
    }

    protected final boolean buildInternally() {
        ModulesConfiguration modules;
        this.buildInitialEnvironment();
        RestartTarget.forWorkingDirectory().attemptToRemoveCommand();
        this.modulesConfiguration = modules = this.buildModuleConfiguration();
        this.buildModules((Iterable<ModuleCreationInformation>)new UpcastingIterable(this.getModuleCreationInformations(modules)));
        this.getLogger().debug((Object)"Modules built, continuing with dependent environment.");
        boolean isComplete = this.buildModuleDependentEnvironment();
        this.registerProcessContextObjects();
        return isComplete;
    }

    protected void reactOnErrorsDuringBuild(Error error) {
        Parameter.isPresent((Object)error);
    }

    public boolean isFullyBuilt() {
        return this.isFullyBuilt;
    }

    protected ModulesConfiguration buildModuleConfiguration() {
        return new ModulesConfiguration((VirtualFile)DeveloperOverdrive.of((VirtualFile)new LocalVirtualFile(this.getSystemConfiguration().getModuleConfigurationFile())), this.configurationSuffix());
    }

    protected abstract SuffixProvider configurationSuffix();

    private void registerProcessContextObjects() {
        for (Object processContextObject : this.getProcessContextObjects()) {
            this.getAbstractApplicationEngine().getProcessContextHandler().registerProcessContextObject(processContextObject);
        }
    }

    private void buildModules(Iterable<ModuleCreationInformation> creationInformations) {
        GenericModuleEngine engine = new GenericModuleEngine(this.getApplicationBus(), new ModuleCreationContextBootMessageLogger((BootMessageLogger)this.splashScreen));
        engine.buildModules(creationInformations);
        this.moduleCreator = new InformedModuleCreator(creationInformations, this.getApplicationBus());
    }

    protected abstract void buildInitialEnvironment();

    protected abstract Iterable<ConfigurableModuleCreationInformation> getModuleCreationInformations(ModulesConfiguration var1);

    protected abstract boolean buildModuleDependentEnvironment();

    protected Iterable<Object> getProcessContextObjects() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add((Object)this.cronStarter);
        result.add((Object)this.modulesConfiguration);
        result.add(this.applicationBus);
        result.add(this.moduleCreator);
        return result;
    }

    protected abstract S createSystemSession();

    protected abstract void start(S var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void stop() {
        this.stopAdditional();
        List<LifeCycle> list = this.dependentResources;
        synchronized (list) {
            DisposeDependentResources.containedIn(this.getProcessContextObjects());
            DisposeDependentResources.givenAsLifecycle(this.dependentResources);
        }
    }

    protected abstract void stopAdditional();

    protected abstract void cleanup();

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getDescription() {
        DirectChunkBuffer result = new DirectChunkBuffer((CharSequence)" ");
        result.append((CharSequence)this.getName());
        result.append((Object)this.getVersion());
        return result.toString();
    }

    @Override
    public final Version getVersion() {
        return this.version;
    }

    @Override
    public final ImageIcon getIcon() {
        return this.icon;
    }

    protected final ApplicationEngine<S, U> getApplicationEngine() {
        return this.applicationEngine;
    }

    protected final SystemConfiguration getSystemConfiguration() {
        return this.systemConfiguration;
    }

    public final ApplicationInformation getApplicationInformation() {
        return this;
    }

    public final SchneideApplication getApplication() {
        return this;
    }

    public static String getBootMessage() {
        return BOOT_MESSAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependent(LifeCycle resource) {
        List<LifeCycle> list = this.dependentResources;
        synchronized (list) {
            this.dependentResources.add(resource);
        }
    }

    @Override
    public String getCronProcessTriggerGroupName() {
        return this.cronStarter.getCronProcessTriggerGroupName();
    }

    private void registerManagementBeans() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.registerMBean(new NewsReceivers(this.getApplicationBus()), new ObjectName("com.schneide:type=NewsReceivers"));
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            this.getLogger().error((Object)"Could not register management bean.", (Throwable)e);
        }
    }

    private static class ModuleCreationContextBootMessageLogger
    implements BootMessageLogger {
        private final BootMessageLogger messageLogger;

        public ModuleCreationContextBootMessageLogger(BootMessageLogger messageLogger) {
            this.messageLogger = messageLogger;
        }

        public void logBootMessage(String message) {
            I18NText fullMessage = new I18NText("boot.message.module.build", new Object[]{message});
            this.messageLogger.logBootMessage(fullMessage.resolvedText());
        }
    }
}

