/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.util;

import java.util.function.Consumer;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.persistence.types.PersistenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceManager;
import org.eclipse.serializer.reference.Swizzling;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.traversing.ObjectGraphTraverser;

public interface Reloader {
    public <T> T reloadFlat(T var1);

    public <T> T reloadDeep(T var1);

    public static Reloader New(PersistenceManager<?> persistenceManager) {
        return new Default((PersistenceManager)X.notNull(persistenceManager));
    }

    public static class Default
    implements Reloader {
        private final PersistenceManager<?> persistenceManager;

        Default(PersistenceManager<?> persistenceManager) {
            this.persistenceManager = persistenceManager;
        }

        private Object reloadObject(Object instance, PersistenceLoader loader) {
            long oid;
            return instance != null && Persistence.IdType.OID.isInRange(oid = this.persistenceManager.lookupObjectId(instance)) ? loader.getObject(oid) : instance;
        }

        @Override
        public <T> T reloadFlat(T instance) {
            X.notNull(instance);
            return (T)this.reloadObject(instance, this.persistenceManager.createLoader());
        }

        @Override
        public <T> T reloadDeep(T instance) {
            X.notNull(instance);
            long oid = this.persistenceManager.lookupObjectId(instance);
            if (Swizzling.isNotFoundId((long)oid)) {
                return null;
            }
            PersistenceLoader loader = this.persistenceManager.createLoader();
            Consumer<Object> logic = object -> this.reloadObject(object, loader);
            ObjectGraphTraverser.Builder().modeFull().acceptorLogic(logic).buildObjectGraphTraverser().traverse(instance);
            return (T)loader.getObject(oid);
        }
    }
}

