/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import org.eclipse.serializer.afs.types.WriteController;
import org.eclipse.serializer.persistence.exceptions.PersistenceExceptionStoringDisabled;
import org.eclipse.serializer.util.X;

@FunctionalInterface
public interface PersistenceWriteController
extends WriteController {
    default public void validateIsStoringEnabled() {
        if (this.isStoringEnabled()) {
            return;
        }
        throw new PersistenceExceptionStoringDisabled();
    }

    default public boolean isStoringEnabled() {
        return this.isWritable();
    }

    public static PersistenceWriteController Wrap(WriteController writeController) {
        return new Wrapper((WriteController)X.notNull((Object)writeController));
    }

    public static PersistenceWriteController Enabled() {
        return new Enabled();
    }

    public static PersistenceWriteController Disabled() {
        return new Disabled();
    }

    public static final class Disabled
    implements PersistenceWriteController {
        Disabled() {
        }

        public final boolean isWritable() {
            return false;
        }

        @Override
        public final boolean isStoringEnabled() {
            return false;
        }
    }

    public static final class Enabled
    implements PersistenceWriteController {
        Enabled() {
        }

        public final void validateIsWritable() {
        }

        @Override
        public final void validateIsStoringEnabled() {
        }

        public final boolean isWritable() {
            return true;
        }

        @Override
        public final boolean isStoringEnabled() {
            return true;
        }
    }

    public static final class Wrapper
    implements PersistenceWriteController {
        private final WriteController writeController;

        Wrapper(WriteController writeController) {
            this.writeController = writeController;
        }

        public final void validateIsWritable() {
            this.writeController.validateIsWritable();
        }

        public final boolean isWritable() {
            return this.writeController.isWritable();
        }

        @Override
        public final boolean isStoringEnabled() {
            return this.isWritable();
        }
    }
}

