/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import java.util.function.Consumer;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberEnumConstant;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberField;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberFieldGeneric;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberFieldGenericComplex;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberFieldGenericVariableLength;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberPrimitiveDefinition;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionary;
import org.eclipse.serializer.persistence.types.TypeDictionaryAppenderBuilder;

public interface PersistenceTypeDescriptionMemberAppender
extends Consumer<PersistenceTypeDescriptionMember> {
    @Override
    public void accept(PersistenceTypeDescriptionMember var1);

    public void appendTypeMemberDescription(PersistenceTypeDescriptionMemberField var1);

    public void appendTypeMemberDescription(PersistenceTypeDescriptionMemberFieldGenericVariableLength var1);

    public void appendTypeMemberDescription(PersistenceTypeDescriptionMemberFieldGenericComplex var1);

    public void appendTypeMemberDescription(PersistenceTypeDescriptionMemberPrimitiveDefinition var1);

    public void appendTypeMemberDescription(PersistenceTypeDescriptionMemberEnumConstant var1);

    public static final class Default
    extends PersistenceTypeDictionary.Symbols
    implements PersistenceTypeDescriptionMemberAppender {
        private static final char[] PRIMITIVE_ = "primitive ".toCharArray();
        private static final char[] ENUM_ = (KEYWORD_ENUM + " ").toCharArray();
        private final VarString vs;
        private final int maxFieldTypeNameLength;
        private final int maxDeclaringTypeNameLength;
        private final int maxFieldNameLength;
        private final int level;

        public Default(VarString vs, int level, int maxFieldTypeNameLength, int maxDeclaringTypeNameLength, int maxFieldNameLength) {
            this.vs = vs;
            this.level = level;
            this.maxFieldTypeNameLength = XMath.notNegative((int)maxFieldTypeNameLength);
            this.maxDeclaringTypeNameLength = XMath.notNegative((int)maxDeclaringTypeNameLength);
            this.maxFieldNameLength = XMath.notNegative((int)maxFieldNameLength);
        }

        private void indentMember() {
            this.vs.repeat(this.level, '\t');
        }

        private void terminateMember() {
            this.vs.add(',').lf();
        }

        private void appendField(PersistenceTypeDescriptionMemberField member) {
            this.vs.padRight(member.typeName(), this.maxFieldTypeNameLength, ' ').blank();
            String qualifier = member.qualifier();
            if (qualifier != null) {
                this.vs.padRight(qualifier, this.maxDeclaringTypeNameLength, ' ').add(PersistenceTypeDictionary.Symbols.MEMBER_FIELD_QUALIFIER_SEPERATOR);
            }
            this.vs.padRight(member.name(), this.maxFieldNameLength, ' ');
        }

        @Override
        public final void accept(PersistenceTypeDescriptionMember typeMember) {
            this.indentMember();
            typeMember.assembleTypeDescription(this);
            this.terminateMember();
        }

        @Override
        public void appendTypeMemberDescription(PersistenceTypeDescriptionMemberField typeMember) {
            this.appendField(typeMember);
        }

        @Override
        public void appendTypeMemberDescription(PersistenceTypeDescriptionMemberFieldGenericVariableLength typeMember) {
            this.appendField(typeMember);
        }

        @Override
        public void appendTypeMemberDescription(PersistenceTypeDescriptionMemberFieldGenericComplex typeMember) {
            this.appendField(typeMember);
            this.vs.add('(').lf();
            XGettingSequence<PersistenceTypeDescriptionMemberFieldGeneric> members = typeMember.members();
            PersistenceTypeDescriptionMemberAppender appender = ((TypeDictionaryAppenderBuilder)((Object)members.iterate((Consumer)((Object)new TypeDictionaryAppenderBuilder(this.vs, this.level + 1))))).yield();
            members.iterate((Consumer)appender);
            this.indentMember();
            this.vs.add(')');
        }

        @Override
        public void appendTypeMemberDescription(PersistenceTypeDescriptionMemberPrimitiveDefinition typeMember) {
            this.vs.add(PRIMITIVE_).add(typeMember.primitiveDefinition());
        }

        @Override
        public void appendTypeMemberDescription(PersistenceTypeDescriptionMemberEnumConstant typeMember) {
            this.vs.add(ENUM_).add(typeMember.name());
        }
    }
}

