/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import java.lang.reflect.Field;
import org.eclipse.serializer.collections.XUtilsCollection;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberEnumConstant;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldGenericComplex;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldGenericSimple;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldGenericVariableLength;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldReflective;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberPrimitiveDefinition;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescription;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberEnumConstant;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberFieldGenericComplex;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberFieldGenericSimple;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberFieldGenericVariableLength;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberFieldReflective;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberPrimitiveDefinition;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionResolver;
import org.eclipse.serializer.util.X;

public interface PersistenceTypeDefinitionMemberCreator {
    public PersistenceTypeDefinitionMemberPrimitiveDefinition createDefinitionMember(PersistenceTypeDescriptionMemberPrimitiveDefinition var1);

    public PersistenceTypeDefinitionMemberEnumConstant createDefinitionMember(PersistenceTypeDescriptionMemberEnumConstant var1);

    public PersistenceTypeDefinitionMemberFieldReflective createDefinitionMember(PersistenceTypeDescriptionMemberFieldReflective var1);

    public PersistenceTypeDefinitionMemberFieldGenericSimple createDefinitionMember(PersistenceTypeDescriptionMemberFieldGenericSimple var1);

    public PersistenceTypeDefinitionMemberFieldGenericVariableLength createDefinitionMember(PersistenceTypeDescriptionMemberFieldGenericVariableLength var1);

    public PersistenceTypeDefinitionMemberFieldGenericComplex createDefinitionMember(PersistenceTypeDescriptionMemberFieldGenericComplex var1);

    public static Default New(XGettingSequence<? extends PersistenceTypeDescription> ascendingOrderTypeIdEntries, PersistenceTypeDescriptionResolver resolver) {
        return new Default((PersistenceTypeDescription[])XUtilsCollection.toArray(ascendingOrderTypeIdEntries, PersistenceTypeDescription.class), (PersistenceTypeDescriptionResolver)X.notNull((Object)resolver));
    }

    public static final class Default
    implements PersistenceTypeDefinitionMemberCreator {
        private final PersistenceTypeDescription[] ascendingOrderTypeIdEntries;
        private final PersistenceTypeDescriptionResolver resolver;

        Default(PersistenceTypeDescription[] ascendingOrderTypeIdEntries, PersistenceTypeDescriptionResolver resolver) {
            this.ascendingOrderTypeIdEntries = ascendingOrderTypeIdEntries;
            this.resolver = resolver;
        }

        @Override
        public PersistenceTypeDefinitionMemberPrimitiveDefinition createDefinitionMember(PersistenceTypeDescriptionMemberPrimitiveDefinition description) {
            return PersistenceTypeDefinitionMemberPrimitiveDefinition.New(description);
        }

        @Override
        public PersistenceTypeDefinitionMemberEnumConstant createDefinitionMember(PersistenceTypeDescriptionMemberEnumConstant description) {
            return PersistenceTypeDefinitionMemberEnumConstant.New(description.name());
        }

        private PersistenceTypeDescription determineLatestTypeEntry(String typeName) {
            PersistenceTypeDescription[] ascendingOrderTypeIdEntries = this.ascendingOrderTypeIdEntries;
            int i = ascendingOrderTypeIdEntries.length;
            while (i-- > 0) {
                if (!typeName.equals(ascendingOrderTypeIdEntries[i].typeName())) continue;
                return ascendingOrderTypeIdEntries[i];
            }
            return null;
        }

        private Class<?> tryResolveCurrentType(String typeName) {
            String effectiveLatestTypeName = this.resolveRuntimeTypeName(typeName);
            return effectiveLatestTypeName == null ? null : this.resolver.tryResolveType(effectiveLatestTypeName);
        }

        private String resolveRuntimeTypeName(String typeName) {
            PersistenceTypeDescription latestTypeEntry = this.determineLatestTypeEntry(typeName);
            String runtimeTypeName = latestTypeEntry == null ? this.resolver.resolveRuntimeTypeName(typeName) : this.resolver.resolveRuntimeTypeName(latestTypeEntry);
            return runtimeTypeName;
        }

        private Field resolveField(String declaringClassName, String fieldName) {
            Class<?> declaringClass = this.resolver.tryResolveType(declaringClassName);
            if (declaringClass == null) {
                return null;
            }
            try {
                Field field = declaringClass.getDeclaredField(fieldName);
                return field;
            }
            catch (NoSuchFieldException e) {
                return null;
            }
        }

        @Override
        public PersistenceTypeDefinitionMemberFieldReflective createDefinitionMember(PersistenceTypeDescriptionMemberFieldReflective description) {
            Class<?> currentType = this.tryResolveCurrentType(description.typeName());
            String runtimeDeclaringType = this.resolveRuntimeTypeName(description.declaringTypeName());
            Field field = description.declaringTypeName().equals(runtimeDeclaringType) ? this.resolveField(runtimeDeclaringType, description.name()) : null;
            return PersistenceTypeDefinitionMemberFieldReflective.New(runtimeDeclaringType, field == null ? null : field.getDeclaringClass(), field, currentType, description.typeName(), description.name(), description.declaringTypeName(), description.isReference(), description.persistentMinimumLength(), description.persistentMaximumLength());
        }

        @Override
        public PersistenceTypeDefinitionMemberFieldGenericSimple createDefinitionMember(PersistenceTypeDescriptionMemberFieldGenericSimple description) {
            Class<?> currentType = this.tryResolveCurrentType(description.typeName());
            return PersistenceTypeDefinitionMemberFieldGenericSimple.New(description.typeName(), description.qualifier(), description.name(), currentType, description.isReference(), description.persistentMinimumLength(), description.persistentMaximumLength());
        }

        @Override
        public PersistenceTypeDefinitionMemberFieldGenericVariableLength createDefinitionMember(PersistenceTypeDescriptionMemberFieldGenericVariableLength description) {
            return PersistenceTypeDefinitionMemberFieldGenericVariableLength.New(description);
        }

        @Override
        public PersistenceTypeDefinitionMemberFieldGenericComplex createDefinitionMember(PersistenceTypeDescriptionMemberFieldGenericComplex description) {
            return PersistenceTypeDefinitionMemberFieldGenericComplex.New(description);
        }
    }
}

