/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import org.eclipse.serializer.math.XMath;

public interface PersistenceSizedArrayLengthController {
    public int controlArrayLength(int var1, int var2);

    public static Unrestricted Unrestricted() {
        return new Unrestricted();
    }

    public static Fitting Fitting() {
        return new Fitting();
    }

    public static Limited Limited(int maximumCapacity) {
        return new Limited(XMath.positive((int)maximumCapacity));
    }

    public static final class Limited
    implements PersistenceSizedArrayLengthController {
        private final int limit;

        Limited(int limit) {
            this.limit = limit;
        }

        public final int limit() {
            return this.limit;
        }

        @Override
        public final int controlArrayLength(int specifiedCapacity, int actualElementCount) {
            return Math.min(specifiedCapacity, Math.max(this.limit, actualElementCount));
        }
    }

    public static final class Fitting
    implements PersistenceSizedArrayLengthController {
        Fitting() {
        }

        @Override
        public final int controlArrayLength(int specifiedCapacity, int actualElementCount) {
            return actualElementCount;
        }
    }

    public static final class Unrestricted
    implements PersistenceSizedArrayLengthController {
        Unrestricted() {
        }

        @Override
        public final int controlArrayLength(int specifiedCapacity, int actualElementCount) {
            return specifiedCapacity;
        }
    }
}

