/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import java.util.function.Supplier;
import org.eclipse.serializer.collections.EqConstHashTable;
import org.eclipse.serializer.collections.EqHashTable;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.persistence.exceptions.PersistenceException;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.persistence.types.PersistenceMetaIdentifiers;
import org.eclipse.serializer.persistence.types.PersistenceRefactoringMappingProvider;
import org.eclipse.serializer.persistence.types.PersistenceRootEntry;
import org.eclipse.serializer.persistence.types.PersistenceRootReference;
import org.eclipse.serializer.persistence.types.PersistenceRootResolver;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionResolverProvider;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandlerManager;
import org.eclipse.serializer.persistence.types.PersistenceTypeResolver;
import org.eclipse.serializer.reference.Reference;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.util.X;

public interface PersistenceRootResolverProvider {
    public PersistenceRootReference rootReference();

    default public String rootIdentifier() {
        return Persistence.rootIdentifier();
    }

    default public boolean hasRootRegistered() {
        PersistenceRootReference rootReference = this.rootReference();
        return rootReference != null && rootReference.get() != null;
    }

    public PersistenceRootResolverProvider setRoot(Object var1);

    default public PersistenceRootResolverProvider registerRoot(String identifier, Object instance) {
        return this.registerRootSupplier(identifier, () -> instance);
    }

    default public PersistenceRootResolverProvider registerRootSupplier(Supplier<?> instanceSupplier) {
        return this.registerRootSupplier(this.rootIdentifier(), instanceSupplier);
    }

    public PersistenceRootResolverProvider registerRootSupplier(String var1, Supplier<?> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public PersistenceRootResolverProvider registerRootSuppliers(XGettingTable<String, Supplier<?>> roots) {
        PersistenceRootResolverProvider persistenceRootResolverProvider = this;
        synchronized (persistenceRootResolverProvider) {
            roots.iterate(kv -> this.registerRootSupplier((String)kv.key(), (Supplier)kv.value()));
        }
        return this;
    }

    public PersistenceRootResolverProvider setTypeDescriptionResolverProvider(PersistenceTypeDescriptionResolverProvider var1);

    public PersistenceRootResolverProvider setRefactoring(PersistenceRefactoringMappingProvider var1);

    public Reference<? extends PersistenceTypeHandlerManager<?>> typeHandlerManager();

    public PersistenceRootResolverProvider setTypeHandlerManager(Reference<? extends PersistenceTypeHandlerManager<?>> var1);

    public PersistenceRootResolver provideRootResolver();

    public static <D> PersistenceRootResolverProvider New(PersistenceRootReference rootReference, PersistenceTypeResolver typeResolver) {
        return PersistenceRootResolverProvider.New(rootReference, typeResolver, PersistenceRootEntry::New);
    }

    public static PersistenceRootResolverProvider New(PersistenceRootReference rootReference, PersistenceTypeResolver typeResolver, PersistenceRootEntry.Provider entryProvider) {
        Default builder = new Default((PersistenceRootReference)X.notNull((Object)rootReference), (PersistenceTypeResolver)X.notNull((Object)typeResolver), (PersistenceRootEntry.Provider)X.notNull((Object)entryProvider));
        return builder;
    }

    public static class Default
    implements PersistenceRootResolverProvider {
        private final PersistenceRootEntry.Provider entryProvider;
        private final PersistenceTypeResolver typeResolver;
        private final EqHashTable<String, PersistenceRootEntry> rootEntries;
        private final PersistenceRootReference rootReference;
        private PersistenceTypeDescriptionResolverProvider typeDescriptionResolverProvider;
        private PersistenceRefactoringMappingProvider refactoringMapping;
        private Reference<? extends PersistenceTypeHandlerManager<?>> refTypeHandlerManager;
        private transient PersistenceRootResolver cachedRootResolver;

        Default(PersistenceRootReference rootReference, PersistenceTypeResolver typeResolver, PersistenceRootEntry.Provider entryProvider) {
            this.rootReference = rootReference;
            this.typeResolver = typeResolver;
            this.entryProvider = entryProvider;
            this.rootEntries = this.initializeRootEntries();
        }

        @Override
        public final synchronized PersistenceRootReference rootReference() {
            return this.rootReference;
        }

        private Supplier<?> createRootReferenceSupplier() {
            PersistenceRootReference rootReference = this.rootReference;
            return () -> rootReference;
        }

        private EqHashTable<String, PersistenceRootEntry> initializeRootEntries() {
            EqHashTable entries = EqHashTable.New();
            for (KeyValue entry : PersistenceMetaIdentifiers.defineConstantSuppliers()) {
                this.initializeEntry((EqHashTable<String, PersistenceRootEntry>)entries, (String)entry.key(), (Supplier)entry.value());
            }
            this.initializeEntry((EqHashTable<String, PersistenceRootEntry>)entries, this.rootIdentifier(), this.createRootReferenceSupplier());
            return entries;
        }

        private void initializeEntry(EqHashTable<String, PersistenceRootEntry> entries, String identifier, Supplier<?> supplier) {
            entries.add((Object)identifier, (Object)this.entryProvider.provideRootEntry(identifier, supplier));
        }

        @Override
        public final synchronized PersistenceRootResolverProvider setRoot(Object root) {
            this.rootReference().setRoot(root);
            return this;
        }

        @Override
        public final synchronized PersistenceRootResolverProvider registerRootSupplier(String identifier, Supplier<?> instanceSupplier) {
            this.addEntry(identifier, instanceSupplier);
            return this;
        }

        private void addEntry(String identifier, Supplier<?> instanceSupplier) {
            PersistenceRootEntry entry = this.entryProvider.provideRootEntry(identifier, instanceSupplier);
            this.addEntry(identifier, entry);
        }

        private void addEntry(String identifier, PersistenceRootEntry entry) {
            if (this.rootEntries.add((Object)identifier, (Object)entry)) {
                return;
            }
            throw new PersistenceException("Root entry already registered for identifier \"" + identifier + "\"");
        }

        private PersistenceRootResolver createRootResolver() {
            PersistenceRootResolver.Default resolver = new PersistenceRootResolver.Default(this.rootIdentifier(), this.rootReference(), (EqConstHashTable<String, PersistenceRootEntry>)this.rootEntries.immure(), this.refTypeHandlerManager);
            PersistenceTypeDescriptionResolverProvider refactoring = this.getEffectiveTypeDescriptionResolver();
            return refactoring == null ? resolver : PersistenceRootResolver.Wrap(resolver, refactoring);
        }

        @Override
        public final synchronized PersistenceRootResolver provideRootResolver() {
            if (this.cachedRootResolver == null) {
                this.cachedRootResolver = this.createRootResolver();
            }
            return this.cachedRootResolver;
        }

        protected PersistenceTypeDescriptionResolverProvider getEffectiveTypeDescriptionResolver() {
            if (this.typeDescriptionResolverProvider != null) {
                return this.typeDescriptionResolverProvider;
            }
            if (this.refactoringMapping != null) {
                return PersistenceTypeDescriptionResolverProvider.Caching(this.typeResolver, this.refactoringMapping);
            }
            return null;
        }

        @Override
        public final synchronized PersistenceRootResolverProvider setTypeDescriptionResolverProvider(PersistenceTypeDescriptionResolverProvider typeDescriptionResolverProvider) {
            this.typeDescriptionResolverProvider = typeDescriptionResolverProvider;
            return this;
        }

        @Override
        public final synchronized PersistenceRootResolverProvider setRefactoring(PersistenceRefactoringMappingProvider refactoringMapping) {
            this.refactoringMapping = refactoringMapping;
            return this;
        }

        @Override
        public synchronized Reference<? extends PersistenceTypeHandlerManager<?>> typeHandlerManager() {
            return this.refTypeHandlerManager;
        }

        @Override
        public synchronized PersistenceRootResolverProvider setTypeHandlerManager(Reference<? extends PersistenceTypeHandlerManager<?>> typeHandlerManager) {
            this.refTypeHandlerManager = typeHandlerManager;
            return this;
        }
    }
}

