/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import java.util.function.Supplier;
import org.eclipse.serializer.persistence.types.PersistenceFunction;
import org.eclipse.serializer.persistence.types.PersistenceRootReferencing;
import org.eclipse.serializer.reference.Reference;
import org.eclipse.serializer.util.X;

public interface PersistenceRootReference
extends PersistenceRootReferencing,
Reference<Object> {
    @Override
    public Object get();

    @Override
    public <F extends PersistenceFunction> F iterate(F var1);

    default public void set(Object newRoot) {
        this.setRoot(newRoot);
    }

    default public Object setRoot(Object newRoot) {
        return this.setRootSupplier(() -> newRoot);
    }

    public Object setRootSupplier(Supplier<?> var1);

    public static PersistenceRootReference New() {
        return PersistenceRootReference.New(null);
    }

    public static PersistenceRootReference New(Object root) {
        Default instance = new Default(null);
        instance.setRoot(root);
        return instance;
    }

    public static PersistenceRootReference New(Supplier<?> rootSupplier) {
        return new Default((Supplier)X.mayNull(rootSupplier));
    }

    public static final class Default
    implements PersistenceRootReference {
        private Supplier<?> rootSupplier;

        public Default(Supplier<?> rootSupplier) {
            this.rootSupplier = rootSupplier;
        }

        @Override
        public final Object get() {
            return this.rootSupplier != null ? this.rootSupplier.get() : null;
        }

        @Override
        public final Object setRootSupplier(Supplier<?> rootSupplier) {
            Object currentRoot = this.get();
            this.rootSupplier = rootSupplier;
            return currentRoot;
        }

        @Override
        public final <F extends PersistenceFunction> F iterate(F iterator) {
            Object currentRoot = this.get();
            if (currentRoot == null) {
                return iterator;
            }
            iterator.apply((Object)currentRoot);
            return iterator;
        }
    }
}

