/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import java.util.function.Supplier;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.util.X;

public interface PersistenceRootEntry {
    public String identifier();

    public Object instance();

    public boolean isRemoved();

    public static PersistenceRootEntry New(String identifier, Supplier<?> instanceSupplier) {
        return new Default((String)X.notNull((Object)identifier), (Supplier)X.mayNull(instanceSupplier));
    }

    @FunctionalInterface
    public static interface Provider {
        public PersistenceRootEntry provideRootEntry(String var1, Supplier<?> var2);
    }

    public static final class Default
    implements PersistenceRootEntry {
        private final String identifier;
        private final Supplier<?> instanceSupplier;

        Default(String identifier, Supplier<?> instanceSupplier) {
            this.identifier = identifier;
            this.instanceSupplier = instanceSupplier;
        }

        @Override
        public final String identifier() {
            return this.identifier;
        }

        @Override
        public boolean isRemoved() {
            return this.instanceSupplier == null;
        }

        @Override
        public final Object instance() {
            return this.instanceSupplier != null ? this.instanceSupplier.get() : null;
        }

        public String toString() {
            return this.identifier + ": " + XChars.systemString((Object)this.instance());
        }
    }
}

